/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.base.io.XMLEncryptUtils;
import com.fr.general.Background;
import com.fr.general.FRLogManager;
import com.fr.general.Inter;
import com.fr.general.ModuleContext;
import com.fr.io.TemplateWorkBookIO;
import com.fr.main.TemplateWorkBook;
import com.fr.main.impl.WorkBook;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.elementcase.TemplateElementCase;
import com.fr.report.module.EngineModule;
import com.fr.stable.StringUtils;
import com.fr.web.WebletException;
import com.fr.web.core.Reportlet;
import com.fr.web.request.ReportletRequest;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysRequiredFieldsService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class AnthorCpt
extends Reportlet {
    public static final String CACHE_PATH = "cache";
    SysAuthorService sysAuthorService = (SysAuthorService)Container.getBean((String)"SysAuthorService");
    SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
    SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"TaskService");
    SysRequiredFieldsService sysRequiredFieldsService = null;

    public TemplateWorkBook createReport(ReportletRequest reportletRequest) throws WebletException {
        TemplateWorkBook workbook = null;
        Env oldEnv = FRContext.getCurrentEnv();
        String cpturl = reportletRequest.getParameter("cpturl") == null ? "" : reportletRequest.getParameter("cpturl").toString();
        String taskid = reportletRequest.getParameter("taskid") == null ? "" : reportletRequest.getParameter("taskid").toString();
        String proid = reportletRequest.getParameter("proid") == null ? "" : reportletRequest.getParameter("proid").toString();
        String rid = reportletRequest.getParameter("rid") == null ? "" : reportletRequest.getParameter("rid").toString();
        String ywType = reportletRequest.getParameter("ywType") == null ? "" : reportletRequest.getParameter("ywType").toString();
        try {
            if (StringUtils.isNotBlank((String)proid) && StringUtils.isNotBlank((String)taskid)) {
                String activitId;
                PfActivityVo pfActivityVo;
                PfWorkFlowInstanceVo wfInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstanceByProId(proid);
                String wfDfid = wfInstanceVo.getWorkflowDefinitionId();
                PfTaskVo pfTask = this.sysTaskService.getTask(taskid);
                String activitDefinitionId = "";
                if (pfTask != null && (pfActivityVo = this.sysTaskService.getActivity(activitId = pfTask.getActivityId())) != null) {
                    activitDefinitionId = pfActivityVo.getActivityDefinitionId();
                }
                if (StringUtils.isNotBlank((String)activitDefinitionId)) {
                    if (cpturl.indexOf("/") > -1) {
                        cpturl = cpturl.replace("/", "\\");
                    }
                    String cptName = cpturl.substring(cpturl.lastIndexOf("\\") + 1, cpturl.length());
                    String cacheFileName = wfDfid + "_" + activitDefinitionId + "_" + cptName + ".cpt";
                    File file = new File(oldEnv.getPath() + "\\" + CACHE_PATH + "\\" + cacheFileName);
                    File filePath = new File(oldEnv.getPath() + "\\" + CACHE_PATH);
                    if (!filePath.exists()) {
                        filePath.mkdirs();
                    }
                    if (!file.exists()) {
                        SAXReader reader = new SAXReader();
                        Document document = reader.read(oldEnv.readBean(cpturl + ".cpt", "reportlets"));
                        this.validateAuthor(taskid, rid, document);
                        this.saveDocument(document, oldEnv.getPath() + "\\" + CACHE_PATH + "\\", cacheFileName);
                        workbook = AnthorCpt.readCacheTemplateWorkBook(oldEnv, cacheFileName);
                        if (StringUtils.isNotBlank((String)ywType)) {
                            this.sysRequiredFieldsService = (SysRequiredFieldsService)Container.getBean((String)ywType);
                        }
                        if (this.sysRequiredFieldsService != null) {
                            new File(oldEnv.getPath() + "\\" + CACHE_PATH + "\\" + cacheFileName).delete();
                            TemplateElementCase report = (TemplateElementCase)workbook.getTemplateReport(0);
                            this.validateBgColor(wfDfid, activitDefinitionId, cptName, report);
                            AnthorCpt.writeCacheTemplateWorkBook(oldEnv, workbook, cacheFileName);
                        }
                    } else {
                        workbook = AnthorCpt.readCacheTemplateWorkBook(oldEnv, cacheFileName);
                    }
                }
            }
            if (workbook == null) {
                workbook = TemplateWorkBookIO.readTemplateWorkBook((Env)oldEnv, (String)(cpturl + ".cpt"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    public static boolean writeCacheTemplateWorkBook(Env var0, TemplateWorkBook var1, String var2) throws Exception {
        FRLogManager.declareResourceWriteStart((String)var2);
        ModuleContext.startModule((String)EngineModule.class.getName());
        try {
            OutputStream var3 = var0.writeBean(var2, CACHE_PATH);
            ((WorkBook)var1).export(var3);
            var3.flush();
            var3.close();
        }
        catch (Exception var7) {
            throw FRLogManager.createLogPackedException((Exception)var7);
        }
        finally {
            FRLogManager.declareResourceWriteEnd();
        }
        return true;
    }

    public void validateAuthor(String taskId, String rid, Document document) throws IOException {
        Element root = document.getRootElement();
        List lstResult = this.sysAuthorService.getTaskFormAuthorList(taskId, "roles", rid);
        if (lstResult != null && lstResult.size() > 0) {
            for (int i = 0; i < lstResult.size(); ++i) {
                PfPartitionInfoVo pfPartitionInfoVo = (PfPartitionInfoVo)lstResult.get(i);
                String elementName = pfPartitionInfoVo.getElementName();
                int operateType = pfPartitionInfoVo.getOperateType();
                List textList = root.selectNodes("//WorkBook/Report/CellElementList/C/Widget/WidgetName[@name='" + elementName + "']");
                if (textList != null && textList.size() > 0) {
                    for (int j = 0; j < textList.size(); ++j) {
                        Node node = (Node)textList.get(j);
                        Element nodeParent = node.getParent();
                        Element elementAttr = (Element)nodeParent.selectSingleNode("WidgetAttr");
                        if (operateType == 1) {
                            elementAttr.addAttribute("disabled", "true");
                            continue;
                        }
                        if (operateType != 2) continue;
                        elementAttr.addAttribute("invisible", "true");
                    }
                    continue;
                }
                List toolBtnList = root.selectNodes("//WorkBook/ReportWebAttr/WebWriteContent/ToolBars/ToolBarManager/ToolBar/Widget/Text[text()='" + elementName + "']");
                if (toolBtnList == null || toolBtnList.size() <= 0) continue;
                for (Element element : toolBtnList) {
                    Element elementParent = element.getParent();
                    Element elementTop = elementParent.getParent();
                    if (operateType != 1 && operateType != 2) continue;
                    elementTop.remove(elementParent);
                }
            }
        }
    }

    public void validateBgColor(String wfDfid, String activitDefinitionId, String cptName, TemplateElementCase report) {
        try {
            List elementList = this.sysRequiredFieldsService.getResourceRequiredFieldsByResourceName(wfDfid, activitDefinitionId, cptName);
            String color = AppConfig.getProperty((String)"RequiredField.bgcolor");
            if (StringUtils.isBlank((String)color)) {
                color = "#fcf7c7";
            }
            if (elementList != null && elementList.size() != 0) {
                Iterator it = report.cellIterator();
                while (it.hasNext()) {
                    TemplateCellElement cell = (TemplateCellElement)it.next();
                    if (cell.getWidget() == null) continue;
                    for (int i = 0; i < elementList.size(); ++i) {
                        String elementName = (String)elementList.get(i);
                        if (!elementName.equals(cell.getWidget().getWidgetName())) continue;
                        Style styleColor = cell.getStyle();
                        ColorBackground background = ColorBackground.getInstance((Color)new Color(Integer.parseInt(color.substring(1), 16)));
                        styleColor = styleColor.deriveBackground((Background)background);
                        cell.setStyle(styleColor);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TemplateWorkBook readCacheTemplateWorkBook(Env var0, String var1) throws Exception {
        if (var1 == null) {
            return null;
        }
        WorkBook var2 = null;
        FRLogManager.declareResourceReadStart((String)var1);
        ModuleContext.startModule((String)EngineModule.class.getName());
        try {
            InputStream var3 = var0.readBean(var1, CACHE_PATH);
            if (var3 == null) {
                throw new FileNotFoundException(Inter.getLocText((String)"NS_exception_noTemplate") + ":" + var1);
            }
            if (var1.endsWith(".cpt")) {
                var2 = new WorkBook();
                var2.readStream(XMLEncryptUtils.decodeInputStream((InputStream)var3));
            } else if (var1.endsWith(".xls")) {
                Class<?> var4 = Class.forName("com.fr.io.importer.ExcelReportImporter");
                var2 = (WorkBook)var4.getMethod("generateWorkBookByStream", InputStream.class).invoke(var4.newInstance(), var3);
            } else if (var1.endsWith(".xlsx")) {
                Class<?> var4 = Class.forName("com.fr.io.importer.Excel2007ReportImporter");
                var2 = (WorkBook)var4.getMethod("generateWorkBookByStream", InputStream.class).invoke(var4.newInstance(), var3);
            }
            var3.close();
        }
        catch (Exception var8) {
            throw FRLogManager.createLogPackedException((Exception)var8);
        }
        finally {
            FRLogManager.declareResourceReadEnd();
        }
        return var2;
    }

    public void saveDocument(Document doc, String path, String name) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(path + name), format);
        writer.write(doc);
        writer.close();
    }

    public void setTplPath(String s) {
    }

    public void setParameterMap(Map map) {
    }
}

