/*
 * Decompiled with CFR 0.152.
 */
package com.gits.etl.web;

import com.gits.etl.model.Job;
import com.gits.etl.web.BaseController;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"job"})
public class JobController
extends BaseController {
    @RequestMapping(method={RequestMethod.GET})
    public String job(Model model) {
        model.addAttribute("jobs", (Object)this.jobManager.getJobs());
        return "job";
    }

    @RequestMapping(value={"install"})
    public String jobInstall(@RequestParam(value="file", required=false) MultipartFile file) throws IOException {
        this.jobManager.installJob(file.getName(), file.getInputStream());
        return "redirect:/job";
    }

    @RequestMapping(value={"run/{name}"})
    @ResponseBody
    public String jobRun(@PathVariable String name) {
        return this.jobManager.runJob(name, null);
    }

    @RequestMapping(value={"edit/{name}"}, method={RequestMethod.GET})
    public String jobEdit(Model model, @PathVariable String name) {
        model.addAttribute("job", (Object)this.jobManager.getJob(name));
        return "job-edit";
    }

    @RequestMapping(value={"edit/{name}"}, method={RequestMethod.POST})
    @ResponseBody
    public Model jobSave(Model model, @PathVariable String name, HttpServletRequest request) {
        Job job = this.jobManager.getJob(name);
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = StringUtils.trim((String)request.getParameter(key));
            if ("_crontab".equals(key)) {
                try {
                    if (StringUtils.isBlank((String)value)) {
                        job.setCrontab(null);
                        continue;
                    }
                    new CronSequenceGenerator(value, TimeZone.getDefault());
                    job.setCrontab(value);
                    continue;
                }
                catch (Exception e) {
                    return this.failed(model, "\u9519\u8bef\u7684crontab\u8868\u8fbe\u5f0f");
                }
            }
            job.getPreferences().put(key, value);
        }
        this.jobManager.saveJob(job);
        return this.success(model);
    }

    @RequestMapping(value={"status/{name}"})
    public String jobStatus(@PathVariable String name) {
        this.jobManager.setJobEnable(name, !this.jobManager.getJob(name).isEnable());
        return "redirect:/job";
    }

    @RequestMapping(value={"remove/{name}"})
    public String jobRemove(@PathVariable String name) {
        this.jobManager.removeJob(name);
        return "redirect:/job";
    }
}

