package com.gits.etl.web;

import com.gits.etl.service.JobReportManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-29
 */
@Controller
@RequestMapping(value = "report")
public class ReportController extends BaseController {
    @Autowired
    private JobReportManager jobReportManager;

    @RequestMapping(value = "/report")
    public String report(
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "result", required = false) Boolean result,
            @RequestParam(value = "startDate", required = false) Date startDate,
            @RequestParam(value = "endDate", required = false) Date endDate,
            @RequestParam(value = "start", defaultValue = "0") int start,
            @RequestParam(value = "num", defaultValue = "20") int num,
            Model model) {
        model.addAttribute("jobs", jobManager.getJobs());
        model.addAttribute("page", jobReportManager.getJobReport(name, result, startDate, endDate, start, num));
        return "report";
    }

    @RequestMapping(value = "view/{id}", method = RequestMethod.GET)
    public String jobEdit(Model model, @PathVariable String id) {
        model.addAttribute("report", jobReportManager.getJobReport(id));
        model.addAttribute("instance", jobManager.getJobInstance(id));
        return "report-view";
    }
}
