package com.gits.etl.web;

import com.gits.etl.service.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-23
 */
public class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    protected JobManager jobManager;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, new CustomDateEditor(new SimpleDateFormat("yyyy-MM-dd HH:mm"), true));
    }

    @ExceptionHandler(Exception.class)
    public String handleException(Exception ex, HttpServletRequest request) {
        logger.debug("handle exception from request [" + request.getPathInfo() + "]", ex);
        request.setAttribute("ex", ex);
        return "error";
    }

    protected Model success(Model model) {
        return model.addAttribute("ret", 0);
    }

    protected Model failed(Model model, String msg) {
        model.addAttribute("msg", msg);
        return model.addAttribute("ret", 1);
    }
}
