package com.gits.etl.service.impl;

import com.gits.etl.model.JobReport;
import com.gits.etl.service.JobReportManager;
import com.gtis.common.Page;
import com.gtis.support.hibernate.HibernateTemplate;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-29
 */
public class JobReportManagerImpl extends HibernateTemplate<JobReport, String> implements JobReportManager {
    @Transactional
    public JobReport saveJobReport(final JobReport jobReport) {
        return save(jobReport);
    }

    public JobReport getJobReport(String id) {
        return get(id);
    }

    public Page<JobReport> getJobReport(String jobName, Boolean result, Date startDate, Date endDate, int start, int limit) {
        List<Criterion> criterions = new ArrayList<Criterion>();
        if (StringUtils.isNotEmpty(jobName)) {
            criterions.add(Restrictions.eq("name", jobName));
        }
        if (result != null) {
            criterions.add(result ? Restrictions.eq("ret", 0) : Restrictions.ne("ret", 0));
        }
        if (startDate != null) {
            criterions.add(Restrictions.gt("startAt", startDate));
        }
        if (endDate != null) {
            criterions.add(Restrictions.lt("startAt", endDate));
        }
        return search(criterions, null, start, limit);
    }
}
