package com.gits.etl.model;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-28
 */
@Entity
public class JobReport implements Serializable {
    private static final long serialVersionUID = -3841659410297654216L;
    @Id
    @Column(length = 32)
    private String id;
    @Column(length = 32, nullable = false)
    private String name;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false)
    private Date startAt;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false)
    private Date finishAt;
    private int ret = -1;
    @Column(length = 4000)
    private String detail;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStartAt() {
        return startAt;
    }

    public void setStartAt(Date startAt) {
        this.startAt = startAt;
    }

    public Date getFinishAt() {
        return finishAt;
    }

    public void setFinishAt(Date finishAt) {
        this.finishAt = finishAt;
    }

    public int getRet() {
        return ret;
    }

    public void setRet(int ret) {
        this.ret = ret;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public int getDuration() {
        if (startAt != null) {
            return (int) ((System.currentTimeMillis() - startAt.getTime()) / 1000);
        }
        return 0;
    }

    public int getRunningTime() {
        return (int) ((finishAt.getTime() - startAt.getTime()));
    }
}
