package com.gits.etl.model;

import com.alibaba.fastjson.JSON;
import com.gits.etl.util.BeanAccessor;
import com.gits.etl.util.DirectBeanAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.Serializable;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-28
 */
public class JobInstance {
    protected final Log LOG = LogFactory.getLog(JobInstance.class);
    private Object job;
    private BeanAccessor jobAccessor;
    private JobReport report;

    public JobInstance(Object job) {
        this.job = job;
        this.jobAccessor = new DirectBeanAccessor(job);
    }

    public int runJob(Map<String, String> params) {
        String[] args = new String[params.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            args[i++] = "--context_param";
            args[i++] = entry.getKey() + "=" + entry.getValue();
        }
        if (LOG.isDebugEnabled())
            LOG.debug("Job param" + Arrays.toString(args));
        ClassLoader oldContextCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(job.getClass().getClassLoader());
            Integer ret = jobAccessor.invoke("runJobInTOS", new Object[]{args});
            if (LOG.isDebugEnabled())
                LOG.debug("Job " + getJobName() + " finished, return code is " + ret);
            return ret;
        } finally {
            Thread.currentThread().setContextClassLoader(oldContextCL);
        }
    }

    public String getJobName() {
        return jobAccessor.getFieldValue("jobName");
    }

    public String getJobVersion() {
        return jobAccessor.getFieldValue("jobVersion");
    }

    public String getProjectName() {
        return jobAccessor.getFieldValue("projectName");
    }

    public String getContextStr() {
        return jobAccessor.getFieldValue("contextStr");
    }

    public Properties getContext() {
        return jobAccessor.invoke("getContext");
    }

    public String getErrorMessage() {
        return jobAccessor.invoke("getExceptionStackTrace");
    }

    public Map<String, Long> getStartHash() {
        return jobAccessor.getFieldValue("start_Hash");
    }

    public Map<String, Long> getEndHash() {
        return jobAccessor.getFieldValue("end_Hash");
    }

    public Map<String, Boolean> getOkHash() {
        return jobAccessor.getFieldValue("ok_Hash");
    }

    public Map<String, Object> getGlobalMap() {
        Map<String, Object> map = new HashMap<String, Object>();
        Map<String, Object> globalMap = jobAccessor.getFieldValue("globalMap");
        for (Map.Entry<String, Object> entry : globalMap.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof Serializable) {
                map.put(entry.getKey(), obj);
            }
        }
        return map;
    }

    public JobReport getReport() {
        return report;
    }

    public void setReport(JobReport report) {
        this.report = report;
    }

    public String getDetail() {
        Map<String, Object> detail = new LinkedHashMap<String, Object>();
        detail.put("global", getGlobalMap());
        detail.put("ok", getOkHash());
        detail.put("end", getEndHash());
        detail.put("start", getStartHash());
        return JSON.toJSONString(detail);
    }
}
