package com.gits.etl.model;

import com.gtis.util.UUIDGenerator;
import org.apache.commons.lang.time.DateUtils;

import java.util.Date;
import java.util.concurrent.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-28
 */
public class JobFuture implements ScheduledFuture {
    private String id;
    private String jobName;
    private ScheduledFuture future;

    public JobFuture(String jobName, ScheduledFuture future) {
        this.id = UUIDGenerator.generate();
        this.future = future;
        this.jobName = jobName;
    }

    public String getId() {
        return id;
    }

    public String getJobName() {
        return jobName;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return future.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return future.isCancelled();
    }

    public boolean isDone() {
        return future.isDone();
    }

    public Object get() throws InterruptedException, ExecutionException {
        return future.get();
    }

    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return future.get(timeout, unit);
    }

    public long getDelay(TimeUnit unit) {
        return future.getDelay(unit);
    }

    @SuppressWarnings("unchecked")
    public int compareTo(Delayed o) {
        return future.compareTo(o);
    }

    public Date getNextTime() {
        return DateUtils.addMilliseconds(new Date(), (int) getDelay(TimeUnit.MILLISECONDS));
    }

    public boolean hasNextTime() {
        return future.getClass().getName().equals("org.springframework.scheduling.concurrent.ReschedulingRunnable");
    }
}
