/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.generic.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtils {
    public static Cookie get(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || name == null || name.length() == 0) {
            return null;
        }
        Cookie cookie = null;
        for (Cookie cooky : cookies) {
            if (!cooky.getName().equals(name)) continue;
            cookie = cooky;
            if (request.getServerName().equals(cookie.getDomain())) break;
        }
        return cookie;
    }

    public static String getValue(HttpServletRequest request, String name) {
        Cookie ci = CookieUtils.get(request, name);
        return ci == null ? null : ci.getValue();
    }

    public static void remove(HttpServletRequest request, HttpServletResponse response, Cookie cookie) {
        if (cookie != null) {
            String path;
            String string = path = request.getContextPath() == null ? "/" : request.getContextPath();
            if ("".equals(path)) {
                path = "/";
            }
            cookie.setPath(path);
            cookie.setValue("");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    public static void set(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        CookieUtils.set(request, response, name, value, 2592000);
    }

    public static void set(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge) {
        String path;
        if (value == null) {
            value = "";
        }
        String string = path = request.getContextPath() == null ? "/" : request.getContextPath();
        if ("".equals(path)) {
            path = "/";
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        response.addCookie(cookie);
    }
}

