/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.common.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UUIDGenerator {
    private static final Logger LOG = Logger.getLogger(UUIDGenerator.class.getName());
    private static AtomicInteger counter = new AtomicInteger(0);
    public static final String identifier = UUIDGenerator.getIP() + UUIDGenerator.getFileNum();

    private static String getCount() {
        counter.compareAndSet(1296, 0);
        return UUIDGenerator.formatString(UUIDGenerator.getHex36String(counter.incrementAndGet()), 2);
    }

    private static String getFileNum() {
        return UUIDGenerator.formatString(String.valueOf(UUIDGenerator.getInstanceSeq()), 1);
    }

    private static int BytestoInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    private static byte[] getInetAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                String name;
                NetworkInterface ni = interfaces.nextElement();
                if (ni.isLoopback() || ni.isVirtual() || ni.isPointToPoint() || !ni.isUp() || (name = ni.getDisplayName().toLowerCase()).contains("convnet") || name.contains("vmnet")) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    byte[] addr = addresses.nextElement().getAddress();
                    if (addr.length != 4) continue;
                    return addr;
                }
            }
        }
        catch (Exception e) {
            LOG.warning("Error to get ip address");
        }
        return null;
    }

    private static String getIP() {
        int ip = 0;
        try {
            ip = UUIDGenerator.BytestoInt(UUIDGenerator.getInetAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return UUIDGenerator.formatString(UUIDGenerator.getHex36String(ip), 3);
    }

    private static byte getInstanceSeq() {
        Preferences prefs = Preferences.userRoot().node("egov");
        int seq = prefs.getInt("uuid-seq", 0);
        if (seq > 36) {
            seq = 0;
        }
        prefs.putInt("uuid-seq", ++seq);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LOG.warning("Error to save uuid-seq");
        }
        return (byte)seq;
    }

    private static String getHex36String(int value) {
        return Integer.toString(value, 36).toUpperCase();
    }

    private static String getHex36String(long value) {
        return Long.toString(value, 36).toUpperCase();
    }

    private static String formatString(String str, int length) {
        if (str.length() == length) {
            return str;
        }
        if (str.length() > length) {
            return str.substring(str.length() - length, str.length());
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length - str.length(); ++i) {
            buf.append("0");
        }
        return buf.append(str).toString();
    }

    public static String getLngTime() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int millSecond = calendar.get(14);
        return UUIDGenerator.formatString(UUIDGenerator.getHex36String(year), 1) + UUIDGenerator.getHex36String(month) + UUIDGenerator.getHex36String(day) + UUIDGenerator.getHex36String(hour) + UUIDGenerator.formatString(String.valueOf(minute), 2) + UUIDGenerator.formatString(String.valueOf(second), 2) + UUIDGenerator.formatString(UUIDGenerator.getHex36String(millSecond), 2);
    }

    public static String generate() {
        return String.valueOf(UUIDGenerator.getLngTime() + identifier + UUIDGenerator.getCount());
    }

    public static String generate18() {
        return UUIDGenerator.generate();
    }

    public static void main(String[] args) {
        System.out.println(identifier);
        for (int i = 0; i < 1000; ++i) {
            System.out.println(UUIDGenerator.generate());
        }
    }
}

