package com.gtis.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-3-23
 */
public class ChildOfAnnotationProcessor implements BeanFactoryPostProcessor, PriorityOrdered {

    protected static final Log LOG = LogFactory.getLog(ChildOfAnnotationProcessor.class);

    private int order = Ordered.LOWEST_PRECEDENCE; // default: same as non-Ordered

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    /**
     * Modify the application context's internal bean factory after its standard
     * initialization. All bean definitions will have been loaded, but no beans
     * will have been instantiated yet. This allows for overriding or adding
     * properties even to eager-initializing beans.
     *
     * @param beanFactory the bean factory used by the application context
     * @throws org.springframework.beans.BeansException
     *          in case of errors
     */
    @SuppressWarnings("unchecked")
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        for (String beanName : beanNames) {
            BeanDefinition bd = beanFactory.getBeanDefinition(beanName);
            String className = bd.getBeanClassName();
// some classnames are nulls, why ?
            if (!StringUtils.hasText(className)) {
                continue;
            }
            try {
                Class clazz = Class.forName(className);
                ChildOf childOf = AnnotationUtils.findAnnotation(clazz,
                        ChildOf.class);
                if (childOf != null) {
                    String parentName = childOf.parent();
                    if (!StringUtils.hasText(parentName)) {
                        throw new FatalBeanException("ChildOf Annotation of bean [" + beanName + "] has no parent Value");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found parentName [" + parentName + "] for bean [" + beanName + "]");
                    }
// is there already a different parent ?
                    String oldParentName = bd.getParentName();
                    if (StringUtils.hasText(oldParentName) && !parentName.equals(oldParentName)) {
                        LOG.warn("bean [" + beanName + "] has already parent [" + oldParentName + "] set - new annotated parent[" + parentName + "] will be ignored");
                    }
// and set the parentName
                    bd.setParentName(parentName);
                }
            } catch (ClassNotFoundException e) {
                LOG.error("Bean [" + beanName + "] has invalid ClassName[" + bd.getBeanClassName() + "] - Exception will be ignored");
            }
        }
    }
}
