package com.gtis.plat.service;

import java.util.Collection;
import java.util.Set;

/**
 * 任务转发相关的服务
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/7/13
 */
public interface SysTaskTurnService {

    /**
     * 获取用户待办任务的默认转发信息，XML格式
     * @param userId 用户Id
     * @param taskId 待办任务Id
     * @return
     */
    public String getTaskDefaultTurnInfo(String userId, String taskId) throws Exception;

    /**
     * 获取用户待办任务的默认转发活动
     * @param userId 用户Id
     * @param taskId 待办任务Id
     * @return
     * @throws Exception
     */
    public Set<String> getTaskDefaultTurnActivity(String userId, String taskId) throws Exception;

    /**
     * 获取用户待办任务的下一个活动默认参与人员Ids
     * @param userId 用户Id
     * @param taskId 待办任务Id
     * @param activityDefinitionId 下一个活动定义Id
     * @return
     * @throws Exception
     */
    public Set<String> getTaskDefaultTurnUser(String userId,String taskId,String activityDefinitionId) throws Exception;

    /**
     * 获取用户待办任务的下一个活动默认参与部门或角色Ids
     * @param userId 用户Id
     * @param taskId 待办任务Id
     * @param activityDefinitionId  下一个活动定义Id
     * @return
     * @throws Exception
     */
    public Set<String> getTaskDefaultTurnOrganOrRole(String userId,String taskId,String activityDefinitionId) throws Exception;

    /**
     * 获取到全局变量中的待办任务的转发信息
     * @param taskId 待办任务Id
     * @param wiid 工作流Id
     * @return
     */
    public String getTurnInfoFromGlobalVal(String taskId,String wiid);

    /**
     * 将待办任务的转发信息更新到全局变量中
     * @param taskId 待办任务Id
     * @param wiid 工作流实例Id
     * @param turnInfo xml格式的转发信息，请参考转发xml格式
     */
    public void updateTurnInfoToGlobalVal(String taskId,String wiid,String turnInfo);



    /**
     * 从用户待办任务的下一个活动的参与者中，移除人员
     * @param userId 用户Id
     * @param taskId 待办任务Id
     * @param activityDefinitionId 下一个活动定义Id
     * @param users 已有用户Ids
     */
    public void removeUserFromTurnInfo(String userId,String taskId,String activityDefinitionId,Collection<String> users) throws Exception;

    /**
     * 从用户待办任务的下一个活动的参与者中，移除角色
     * @param userId 用户Id
     * @param taskId 待办任务Id
     * @param activityDefinitionId 下一个活动定义Id
     * @param roles 已有角色Ids
     */
    public void removeRoleFromTurnInfo(String userId,String taskId,String activityDefinitionId,Collection<String> roles) throws Exception;

    /**
     * 从用户待办任务的下一个活动的参与者中，移除部门
     * @param userId 用户Id
     * @param taskId 待办任务Id
     * @param activityDefinitionId 下一个活动定义Id
     * @param organs 已有部门Ids
     */
    public void removeOrganFromTurnInfo(String userId,String taskId,String activityDefinitionId,Collection<String> organs) throws Exception;

    /**
     * 重新设置用户待办任务的下一个活动的参与角色的人员
     * @param userId 用户Id
     * @param taskId 待办任务Id
     * @param activityDefinitionId 下一个活动定义Id
     * @param roleId 参与角色Id
     * @param users 新用户Ids
     */
    public void resetRoleUser(String userId,String taskId,String activityDefinitionId,String roleId,Collection<String> users) throws Exception;

    /**
     * 重新设置用户待办任务的下一个活动的参与部门的人员
     * @param userId 用户Id
     * @param taskId 待办任务Id
     * @param activityDefinitionId 下一个活动定义Id
     * @param organId 参与部门Id
     * @param users 新用户Ids
     */
    public void resetOrganUser(String userId,String taskId,String activityDefinitionId,String organId,Collection<String> users) throws Exception;

    /**
     * 清空用户待办任务的下一个活动的所有参与者信息
     * @param userId 用户Id
     * @param taskId 待办任务Id
     * @param activityDefinitionId 下一个活动定义Id
     * @param isActivityRemoved 参与者信息删除后，是否同时删除该活动信息。
     *                          如果删除了该活动信息，那么待办任务将无法转发给这个活动，如果不删除，则后续需往该活动中重新添加参与者信息。
     */
    public void removeActivityUsers(String userId,String taskId,String activityDefinitionId,Boolean isActivityRemoved) throws Exception;
}
