package com.gtis.plat.service;


import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfFormDefineVo;
import com.gtis.plat.vo.PfUserSignVo;

public interface SysFormService {

    /**
     * 根据表单获取业务信息
     * @param formDefineVo
     * @return
     */
    public abstract PfBusinessVo getBusiness(PfFormDefineVo formDefineVo);

    /**
     * 获取表单定义对象
     * @param defineId
     * @return
     */
    public abstract PfFormDefineVo getFormDefine(String defineId);


    /**
     * 获取表单对象  简单
     * @param defineId
     * @return
     */
    public abstract PfFormDefineVo getFormDefineSimple(String defineId);

    /**
     * 用户签名对象
     * @param userId
     * @return
     */
    public abstract PfUserSignVo getSignUserImage(String userId);

    /**
     * 用户签名对象
     * @param signId
     * @return
     */
    public abstract PfUserSignVo getSign(String signId);

    /**
     * 新建签名
     * @param signVo
     */
    public abstract void createSign(PfUserSignVo signVo);

}