package com.gtis.plat.rss;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;

/**
 * @(#)RssBuilder.java 2010-5-31 17:54:04
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					: 创建Rss记录接口
 * Version					:
 * CreateAuthor             : ShiHui
 */
public interface RssBuilder<T> {

    /**
     * 获得指定分页的Rss信息对象
     *
     * @return
     */
    public SyndFeed getFeed(int start, int limit);

    /**
     * 将对象转换为Rss记录
     *
     * @param obj 对象
     * @return inde
     */
    public SyndEntry convert(T obj);

    /**
     * 生成对象对应的url地址
     *
     * @param param 参数列表
     * @return url
     */
    public String getUrl(String... param);
}
