/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: MimeTypeServiceImpl.java
 *
 * LastModified: 2009-09-21 03:15:36
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.service.impl;

import com.gtis.fileCenter.ex.NestedRuntimeException;
import com.gtis.fileCenter.service.MimeTypeService;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilderFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-16
 */
public class MimeTypeServiceImpl implements MimeTypeService {

    public static final String DEFAULT_CONFIG = "mimetype-map.xml";

    private Map<String, String> extensionsByMimetype;
    private Map<String, String> mimeTypesByExtension;
    private Map<String, String> iconsByExtension;

    public MimeTypeServiceImpl() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(getClass().getResourceAsStream(DEFAULT_CONFIG));
            List list = DomUtils.getChildElementsByTagName(doc.getDocumentElement(), "mime-mapping");
            extensionsByMimetype = new HashMap<String, String>(list.size());
            mimeTypesByExtension = new HashMap<String, String>(list.size());
            iconsByExtension = new HashMap<String, String>(list.size());
            for (Object o : list) {
                Element ele = (Element) o;
                String extension = DomUtils.getChildElementValueByTagName(ele, "extension");
                String mimeType = DomUtils.getChildElementValueByTagName(ele, "mime-type");
                String icon = DomUtils.getChildElementValueByTagName(ele, "icon");
                extensionsByMimetype.put(mimeType, extension);
                mimeTypesByExtension.put(extension, mimeType);
                if (icon != null)
                    iconsByExtension.put(extension, icon);
            }
        } catch (Exception e) {
            throw new NestedRuntimeException("parse mimeType file: " + DEFAULT_CONFIG + " error", e);
        }
    }

    public String getExtension(String mimeType) {
        return extensionsByMimetype.get(mimeType);
    }

    public String getIcon(String fileName) {
        String ext = getExt(fileName);
        if (ext != null && iconsByExtension.containsKey(ext)) {
            return iconsByExtension.get(ext);
        }
        return ICON_UNKOWN;
    }

    public String getMimeType(String fileName) {
        String ext = getExt(fileName);
        if (ext != null && mimeTypesByExtension.containsKey(ext)) {
            return mimeTypesByExtension.get(ext);
        }
        return MIMETYPE_BINARY;
    }

    private String getExt(String fileName) {
        if (fileName != null) {
            int index = fileName.lastIndexOf('.');
            if (index > -1 && (index < fileName.length() - 1)) {
                return fileName.substring(index + 1).toLowerCase();
            }
        }
        return null;
    }
}
