package com.gtis.dform.action;

import com.gtis.common.util.ByteObjectAccess;
import com.gtis.dform.excute.FormExcuteSplit;
import com.gtis.web.SplitParam;
import com.opensymphony.xwork2.Action;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateHashModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.apache.struts2.json.annotations.JSON;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 系统配置页面
 *
 * @author jiff
 */
public class DFormSplitDataAction implements Action {

    private static final long serialVersionUID = 8321151070525915186L;
    private List<Object> rows; // 记录
    private int totalCount; // 记录总数
    private int start; // 开始记录
    private int limit; // 页大小
    private String splitInfo; // 分页信息，含查询字段
    private String sort; //排序字段
    private String dir; //排序方式
    private String queryString; // 查询字段
    FormExcuteSplit formExcuteSplit;

    public void setFormExcuteSplit(FormExcuteSplit formExcuteSplit) {
        this.formExcuteSplit = formExcuteSplit;
    }

    //以下输出用
    private List<String[]> fields;
    private String caption;

    private TemplateHashModel convertMethod;

    public TemplateHashModel getConvertMethod() {
        return convertMethod;
    }

    public void setConvertMethod(TemplateHashModel convertMethod) {
        this.convertMethod = convertMethod;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getDir() {
        return dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    @JSON(deserialize = false, serialize = false)
    public List<String[]> getFields() {
        return fields;
    }

    public void setFields(List<String[]> fields) {
        this.fields = fields;
    }

    @JSON(deserialize = false, serialize = false)
    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    protected static final Log log = LogFactory.getLog(DFormSplitDataAction.class);

    @JSON(deserialize = false, serialize = false)
    public String getSplitInfo() {
        return splitInfo;
    }


    public void setSplitInfo(String splitInfo) {
        this.splitInfo = splitInfo;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public List<Object> getRows() {
        return rows;
    }

    public void setRows(List<Object> rows) {
        this.rows = rows;
    }

    @SuppressWarnings("unchecked")
    public String execute() throws Exception {
        SplitParam splitParam = (SplitParam) ByteObjectAccess
                .stringToObject(splitInfo);
        if (splitParam != null) {
            HashMap paramMap = null;
            if (splitParam.getQueryParam() != null && !(splitParam.getQueryParam() instanceof Map)) {
                splitParam.setQueryParam(splitParam.getQueryParam());
            } else {
                if (splitParam.getQueryParam() != null && splitParam.getQueryParam() instanceof Map)
                    paramMap = (HashMap) splitParam.getQueryParam();
                else
                    paramMap = new HashMap<String, String>();
                // HashMap<String,String> map=new HashMap<String,String>();
                // map.put("_orderfield_", sort);
                // SplitParamImpl ss=(SplitParamImpl)splitParam;
                // ss.setQueryParam(map);

                // HashMap ddd;

                if (queryString != null && !queryString.equals("")) {
                    queryString = java.net.URLDecoder.decode(queryString, "UTF-8");
                    Object obj = JSONUtil.deserialize(queryString);
                    HashMap paramMapOld = (HashMap) obj;
                    if (paramMapOld != null) {
                        paramMap.putAll(paramMapOld);
                    }
                }
                if (!StringUtils.isBlank(sort)) {
                    paramMap.put("_orderfield_", this.sort);
                    paramMap.put("_orderdir_", this.dir);
                }

                splitParam.setQueryParam(paramMap);
            }
            //rows = pageDataAccess.queryForListOrderby(splitParam, start, limit);
            rows = formExcuteSplit.queryForList(splitParam, start, limit);
        } else
            log.error("----列表参数无法获取------");
        return SUCCESS;
    }

    public String excel() throws Exception {
        //this.convertMethod=new com.gtis.web.taglib.common.ConverObjectMethod();
        ServletActionContext.getContext().getContextMap().put("ConverObjectMethod", new com.gtis.common.util.ConverObjectMethod());
        String result = ServletActionContext.getRequest().getParameter("result");
        if (result == null || result.equals(""))
            result = "excel";
        String fieldsString = ServletActionContext.getRequest().getParameter("fields");
        fields = new ArrayList<String[]>();

        if (fieldsString != null && !fieldsString.equals("")) {
            String[] fArray = fieldsString.split(";");
            for (String str : fArray) {
                if (!str.trim().equals("")) {
                    String[] a = str.split(",");
                    if (a.length == 3)
                        fields.add(a);
                }
            }
        }

        SplitParam splitParam = (SplitParam) ByteObjectAccess
                .stringToObject(splitInfo);
        if (queryString != null && !queryString.equals("")) {
            //queryString = java.net.URLDecoder.decode(queryString, "UTF-8");
            Object obj = JSONUtil.deserialize(queryString);
            HashMap paramMap = (HashMap) obj;
            if (splitParam.getQueryParam() != null) {
                HashMap paramMapOld = (HashMap) splitParam.getQueryParam();
                paramMap.putAll(paramMapOld);
            }
            splitParam.setQueryParam(paramMap);
        }

        if (splitParam != null)
//            rows = pageDataAccess.getSqlMapClientTemplate().queryForList(
//                    splitParam.getQueryString(), splitParam.getQueryParam());
            rows = formExcuteSplit.queryForList(splitParam, 0, 5000);
        String fileName = "default";

        if (caption != null && !caption.equals(""))
            fileName = new String(caption.getBytes(), "iso8859-1");


        //////

        BeansWrapper wrapper = BeansWrapper.getDefaultInstance();
        TemplateHashModel staticModels = wrapper.getStaticModels();
        this.convertMethod =
                (TemplateHashModel) staticModels.get("com.gtis.web.taglib.common.ConverObjectMethod");
        ///
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment; filename=\"" + fileName + ".xls\"");
        return result;
    }

    @SuppressWarnings("unchecked")
    public String RowCount() throws Exception {
        SplitParam splitParam = (SplitParam) ByteObjectAccess
                .stringToObject(splitInfo);
        //queryString= splitParam.getQueryString();
        if (queryString != null && !queryString.equals("")) {
            Object obj = JSONUtil.deserialize(queryString);
            HashMap<String, Object> paramMap = (HashMap<String, Object>) obj;
            if (splitParam.getQueryParam() != null) {
                HashMap paramMapOld = (HashMap) splitParam.getQueryParam();
                paramMap.putAll(paramMapOld);
            }
            if (splitParam.getQueryParam() != null) {
                HashMap paramMapOld = (HashMap) splitParam.getQueryParam();
                paramMap.putAll(paramMapOld);
            }
            splitParam.setQueryParam(paramMap);
        }
        totalCount = formExcuteSplit.getCount(splitParam);
        // String result="{\"totalCount\":"+totalCount+"}";
        ServletActionContext.getResponse().getWriter().println(totalCount);
        return Action.NONE;
    }

    @JSON(deserialize = false, serialize = false)
    public int getStart() {
        return start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @JSON(deserialize = false, serialize = false)
    public int getLimit() {
        return limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @JSON(deserialize = false, serialize = false)
    public String getQueryString() {
        return queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

}
