/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.support.hibernate;

import com.gtis.common.Page;
import com.gtis.support.hibernate.HibernateDao;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.util.Assert;

public class HibernateTemplate<T, PK extends Serializable>
extends HibernateDao {
    protected Class<T> entityClass;

    public HibernateTemplate() {
        Type[] params;
        Type genType = this.getClass().getGenericSuperclass();
        Class clazz = !(genType instanceof ParameterizedType) ? Object.class : (!((params = ((ParameterizedType)genType).getActualTypeArguments())[0] instanceof Class) ? Object.class : (Class)params[0]);
        this.entityClass = clazz;
    }

    public HibernateTemplate(SessionFactory sessionFactory) {
        this();
        this.sessionFactory = sessionFactory;
    }

    public HibernateTemplate(HibernateDao hibernateDao, Class entityClass) {
        this.sessionFactory = hibernateDao.getSessionFactory();
        this.entityClass = entityClass;
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.getSession().delete(entity);
        this.logger.debug("delete entity: {}", entity);
    }

    public void delete(PK id) {
        Assert.notNull(id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.delete((PK)this.get(id));
        this.logger.debug("delete entity {},id is {}", (Object)this.entityClass.getSimpleName(), id);
    }

    public T load(PK id) {
        Assert.notNull(id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return (T)this.getSession().load(this.entityClass, id);
    }

    public T get(PK id) {
        Assert.notNull(id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return (T)this.getSession().get(this.entityClass, id);
    }

    public List<T> findBy(String propertyName, Object value) {
        Assert.hasText((String)propertyName, (String)"propertyName\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleExpression criterion = Restrictions.eq((String)propertyName, (Object)value);
        return this.find(new Criterion[]{criterion});
    }

    public List<T> find(Criterion ... criterions) {
        return this.createCriteria(criterions).list();
    }

    public List<T> findByIds(List<PK> ids) {
        return this.find(Restrictions.in((String)this.getIdName(), ids));
    }

    public String getIdName() {
        ClassMetadata meta = this.getSessionFactory().getClassMetadata(this.entityClass);
        return meta.getIdentifierPropertyName();
    }

    public T findUnique(Criterion ... criterions) {
        return (T)this.createCriteria(criterions).uniqueResult();
    }

    public T findUniqueBy(String propertyName, Object value) {
        Assert.hasText((String)propertyName, (String)"propertyName\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleExpression criterion = Restrictions.eq((String)propertyName, (Object)value);
        return (T)this.createCriteria(new Criterion[]{criterion}).uniqueResult();
    }

    public List<T> getAll() {
        return this.find(new Criterion[0]);
    }

    public List<T> getAll(String orderBy, boolean isAsc) {
        Criteria c = this.createCriteria(new Criterion[0]);
        if (isAsc) {
            c.addOrder(Order.asc((String)orderBy));
        } else {
            c.addOrder(Order.desc((String)orderBy));
        }
        return c.list();
    }

    public Page<T> search(int start, int limit, Order[] orders, Criterion ... criterions) {
        return this.search(Arrays.asList(criterions), Arrays.asList(orders), start, limit);
    }

    public Page<T> search(int start, int limit, Order order, Criterion ... criterions) {
        return this.search(Arrays.asList(criterions), Arrays.asList(order), start, limit);
    }

    public Page<T> search(List<? extends Criterion> criterions, List<Order> orders, int start, int limit) {
        return this.search(this.entityClass, criterions, orders, start, limit);
    }

    public Criteria createCriteria(Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        for (Criterion c : criterions) {
            criteria.add(c);
        }
        return criteria;
    }

    public T save(T entity) {
        Assert.notNull(entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.getSession().saveOrUpdate(entity);
        this.logger.debug("save entity: {}", entity);
        return entity;
    }

    public T merge(T entity) {
        Assert.notNull(entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.getSession().merge(entity);
        this.logger.debug("save entity: {}", entity);
        return entity;
    }
}

