/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.support.hibernate;

import com.gtis.common.Page;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.util.Assert;

public class HibernateDao {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public int batchExecute(String hql, Object ... values) {
        return this.createQuery(hql, values).executeUpdate();
    }

    public int batchExecute(String hql, Map<String, ?> values) {
        return this.createQuery(hql, values).executeUpdate();
    }

    public Query createQuery(String queryString, Object ... values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return query;
    }

    public Query createQuery(String queryString, Map<String, ?> values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            query.setProperties(values);
        }
        return query;
    }

    public Query distinct(Query query) {
        query.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return query;
    }

    public Criteria distinct(Criteria criteria) {
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria;
    }

    public <X> List<X> find(String hql, Object ... values) {
        return this.createQuery(hql, values).list();
    }

    public <X> List<X> find(String hql, Map<String, ?> values) {
        return this.createQuery(hql, values).list();
    }

    public <X> X findUnique(String hql, Object ... values) {
        return (X)this.createQuery(hql, values).uniqueResult();
    }

    public <X> X findUnique(String hql, Map<String, ?> values) {
        return (X)this.createQuery(hql, values).uniqueResult();
    }

    public void flush() {
        this.getSession().flush();
    }

    protected final Session getSession() throws DataAccessResourceFailureException, IllegalStateException {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
    }

    public void initProxyProperty(Object proxyProperty) {
        Hibernate.initialize((Object)proxyProperty);
    }

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.afterSessionFactorySet();
    }

    public <T> Page<T> search(Class clazz, List<? extends Criterion> criterions, List<Order> orders, int start, int limit) {
        Criteria criteria = this.getSession().createCriteria(clazz);
        if (criterions != null) {
            for (Criterion criterion : criterions) {
                if (criterion == null) continue;
                criteria.add(criterion);
            }
        }
        if (orders != null) {
            for (Order order : orders) {
                if (order == null) continue;
                criteria.addOrder(order);
            }
        }
        return this.search(criteria, start, limit);
    }

    public <T> Page<T> search(Criteria criteria, int start, int limit) {
        Page page = new Page(Page.toIndex(start, limit), limit);
        if (limit == -1) {
            List items = criteria.list();
            page.setItems(items);
            page.setTotalCount(items.size());
        } else {
            int totalCount = HibernateDao.toInt((Long)criteria.setProjection(Projections.rowCount()).uniqueResult(), 0);
            page.setTotalCount(totalCount);
            if (totalCount > 0) {
                criteria.setFirstResult(start).setMaxResults(limit);
                page.setItems(criteria.setProjection(null).setResultTransformer(CriteriaSpecification.ROOT_ENTITY).list());
            }
        }
        return page;
    }

    protected static int toInt(Long v, int def) {
        if (v == null) {
            return def;
        }
        return v.intValue();
    }

    protected void afterSessionFactorySet() {
    }
}

