/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sql.dialect;

import com.gtis.sql.dialect.Dialect;

public class MySqlDialect
implements Dialect {
    protected static final String SQL_END_DELIMITER = ";";

    @Override
    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 20).append(this.trim(sql)).append(hasOffset ? " limit ?,?" : " limit ?").append(SQL_END_DELIMITER).toString();
    }

    @Override
    public String getLimitString(String sql, int offset, int limit) {
        sql = this.trim(sql);
        StringBuffer sb = new StringBuffer(sql.length() + 20);
        sb.append(sql);
        if (offset > 0) {
            sb.append(" limit ").append(offset).append(',').append(limit).append(SQL_END_DELIMITER);
        } else {
            sb.append(" limit ").append(limit).append(SQL_END_DELIMITER);
        }
        return sb.toString();
    }

    @Override
    public String getLimitString(String sql, int offset, int limit, String orderField, boolean desc) {
        return this.getLimitString(sql, offset, limit);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    private String trim(String sql) {
        if ((sql = sql.trim()).endsWith(SQL_END_DELIMITER)) {
            sql = sql.substring(0, sql.length() - 1 - SQL_END_DELIMITER.length());
        }
        return sql;
    }
}

