/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.search;

import com.gtis.search.AbstractIndexTemplateSupport;
import com.gtis.search.Business;
import com.gtis.search.Category;
import com.gtis.search.CategoryFactory;
import com.gtis.search.DataFetcher;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DefaultCategoryFactory
extends AbstractIndexTemplateSupport
implements CategoryFactory {
    protected Category category;
    protected Set<String> unSearchableFields = new HashSet<String>();
    protected List<DataFetcher> dataFetchers;

    public DefaultCategoryFactory() {
        this.category = new Category();
    }

    public void setId(String id) {
        this.category.setId(id);
    }

    public void setName(String name) {
        this.category.setName(name);
    }

    public void setIcon(String icon) {
        this.category.setIcon(icon);
    }

    @Override
    public void setTplVars(Map<String, Serializable> vars) {
        this.category.setTplVars(vars);
    }

    @Override
    public void setTplText(String name, String text) {
        this.category.addTpl(name, StringUtils.replace((String)text, (String)"%{", (String)"${"));
    }

    public void setUnSearchableFieldArray(String[] unSearchableFields) {
        Collections.addAll(this.unSearchableFields, unSearchableFields);
    }

    public void setDataFetchers(List<DataFetcher> dataFetchers) {
        this.dataFetchers = dataFetchers;
    }

    @Override
    public String getId() {
        return this.category.getId();
    }

    @Override
    public Category getCategory(Business business) {
        this.prepareCategory(business, this.category);
        return this.category;
    }

    protected void prepareCategory(Business business, Category category) {
        if (category.getBusinessId() == null) {
            category.setBusinessId(business.getId());
        }
        if (this.dataFetchers != null) {
            for (DataFetcher dataFetcher : this.dataFetchers) {
                this.prepareDataFetcher(business, category, dataFetcher);
            }
        }
        this.reloadTpl();
    }

    protected void prepareDataFetcher(Business business, Category category, DataFetcher dataFetcher) {
    }

    @Override
    public List<DataFetcher> getDataFetchers() {
        return this.dataFetchers;
    }

    @Override
    public Set<String> getUnSearchableFields() {
        return this.unSearchableFields;
    }
}

