/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.model.impl;

import com.gtis.fileCenter.model.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public class NodeImpl
implements Node {
    private static final long serialVersionUID = 888300615574833294L;
    private Integer id;
    private Integer parentId;
    private int type = 0;
    private int scope = 0;
    private String owner;
    private String name;
    private String viewName;
    private String icon;
    private String path;
    private Map<String, String> attributes;
    private String description;
    private Date updateTime;
    private transient Map<String, NodeImpl> children;
    private Integer childCount;
    private boolean writeable = false;

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getScope() {
        return this.scope;
    }

    @Override
    public void setScope(int scope) {
        this.scope = scope;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, value);
    }

    @Override
    public String getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    @Override
    public String getAttribute(String key, String defaultValue) {
        String value = null;
        if (this.attributes != null) {
            value = this.attributes.get(key);
        }
        return value == null ? defaultValue : value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public List<Node> getChildren() {
        if (this.children == null) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(this.children.size());
        for (NodeImpl n : this.children.values()) {
            try {
                nodes.add(n.clone());
            }
            catch (CloneNotSupportedException ignored) {}
        }
        Collections.sort(nodes);
        return nodes;
    }

    public void setChildren(List<Node> nodes) {
        if (nodes == null) {
            this.children = null;
            this.childCount = 0;
            return;
        }
        this.children = new LinkedHashMap<String, NodeImpl>(nodes.size());
        for (Node node : nodes) {
            this.children.put(node.getName(), (NodeImpl)node);
        }
        this.childCount = nodes.size();
    }

    public boolean isChildrenUnSet() {
        return this.children == null;
    }

    public NodeImpl getChild(String name) {
        if (this.children != null) {
            return this.children.get(name);
        }
        return null;
    }

    public void addChild(Node node) {
        if (this.children != null) {
            this.children.put(node.getName(), (NodeImpl)node);
            Integer n = this.childCount;
            Integer n2 = this.childCount = Integer.valueOf(this.childCount + 1);
        }
    }

    public void removeChild(String name) {
        if (this.children != null && this.children.containsKey(name)) {
            this.children.remove(name);
            Integer n = this.childCount;
            Integer n2 = this.childCount = Integer.valueOf(this.childCount - 1);
        }
    }

    @Override
    public Integer getChildCount() {
        return this.childCount;
    }

    public void setChildCount(Integer childCount) {
        this.childCount = childCount;
    }

    @Override
    public boolean isWriteable() {
        return this.writeable;
    }

    public void setWriteable(boolean writeable) {
        this.writeable = writeable;
    }

    public String getFullPath() {
        return this.getPath() + this.getId() + "/";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int code = 0;
        if (this.parentId != null) {
            code = this.parentId;
        }
        if (this.name != null) {
            code = code * 31 + this.name.hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        Node n = (Node)o;
        return this.id != null && this.id.equals(n.getId());
    }

    @Override
    public Node clone() throws CloneNotSupportedException {
        return (Node)super.clone();
    }

    @Override
    public int compareTo(Node o) {
        int ret = this.getType() - o.getType();
        return ret == 0 ? this.getName().compareTo(o.getName()) : ret;
    }
}

