/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.ibatis;

import com.gtis.common.util.ReflectUtil;
import com.gtis.ibatis.OrderByStatementUtil;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.AutoResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.ExecuteListener;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.mapping.statement.SelectStatement;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

class OrderByStatement
extends SelectStatement {
    public OrderByStatement(SelectStatement selectStatement) {
        this.setId(OrderByStatementUtil.getOrderByStatementId(selectStatement.getId()));
        this.setResultSetType(selectStatement.getResultSetType());
        this.setFetchSize(1);
        this.setParameterMap(selectStatement.getParameterMap());
        this.setParameterClass(selectStatement.getParameterClass());
        this.setSql(selectStatement.getSql());
        this.setResource(selectStatement.getResource());
        this.setSqlMapClient(selectStatement.getSqlMapClient());
        this.setTimeout(selectStatement.getTimeout());
        List executeListeners = (List)ReflectUtil.getFieldValue(selectStatement, "executeListeners", List.class);
        if (executeListeners != null) {
            for (Object listener : executeListeners) {
                this.addExecuteListener((ExecuteListener)listener);
            }
        }
        AutoResultMap resultMap = new AutoResultMap(((ExtendedSqlMapClient)this.getSqlMapClient()).getDelegate(), false);
        resultMap.setId(this.getId() + "-AutoResultMap");
        resultMap.setResultClass(Long.class);
        resultMap.setResource(this.getResource());
        this.setResultMap((ResultMap)resultMap);
    }

    protected void executeQueryWithCallback(StatementScope statementScope, Connection conn, Object parameterObject, Object resultObject, RowHandler rowHandler, int skipResults, int maxResults) throws SQLException {
        ErrorContext errorContext = statementScope.getErrorContext();
        errorContext.setActivity("preparing the mapped statement for execution");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        try {
            parameterObject = this.validateParameter(parameterObject);
            Sql sql = super.getSql();
            errorContext.setMoreInfo("Check the parameter map.");
            ParameterMap parameterMap = sql.getParameterMap(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the result map.");
            ResultMap resultMap = sql.getResultMap(statementScope, parameterObject);
            statementScope.setResultMap(resultMap);
            statementScope.setParameterMap(parameterMap);
            errorContext.setMoreInfo("Check the parameter map.");
            Object[] parameters = parameterMap.getParameterObjectValues(statementScope, parameterObject);
            errorContext.setMoreInfo("Check the SQL statement.");
            String sqlString = sql.getSql(statementScope, parameterObject);
            sqlString = this.getSqlString(statementScope, parameterObject, sql);
            errorContext.setActivity("executing mapped statement");
            errorContext.setMoreInfo("Check the SQL statement or the result map.");
            RowHandlerCallback callback = new RowHandlerCallback(resultMap, resultObject, rowHandler);
            this.sqlExecuteQuery(statementScope, conn, sqlString, parameters, skipResults, maxResults, callback);
            errorContext.setMoreInfo("Check the output parameters.");
            if (parameterObject != null) {
                this.postProcessParameterObject(statementScope, parameterObject, parameters);
            }
            errorContext.reset();
            sql.cleanup(statementScope);
            this.notifyListeners();
        }
        catch (SQLException e) {
            errorContext.setCause((Throwable)e);
            throw new NestedSQLException(errorContext.toString(), e.getSQLState(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            errorContext.setCause((Throwable)e);
            throw new NestedSQLException(errorContext.toString(), (Throwable)e);
        }
    }

    private String getSqlString(StatementScope stateScope, Object parameterObject, Sql sql) {
        Map parameterMap;
        String sqlString = sql.getSql(stateScope, parameterObject);
        if (parameterObject instanceof Map && (parameterMap = (Map)parameterObject).get("_orderfield_") != null) {
            String orderField = parameterMap.get("_orderfield_").toString();
            String orderDir = "";
            if (parameterMap.get("_orderfield_") != null) {
                orderDir = parameterMap.get("_orderfield_").toString();
            }
            sqlString = sqlString.trim();
            sqlString = "select * from (" + sqlString + ") order by " + orderField + " " + orderDir;
        }
        return sqlString;
    }

    private ResultMap getResultMap(StatementScope stateScope, Object parameterObject, Sql sql) {
        return this.getResultMap();
    }
}

