/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.generic.security;

import com.gtis.generic.security.EgovServiceProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.cas.CasAuthenticationToken;
import org.springframework.security.providers.cas.StatelessTicketCache;
import org.springframework.security.providers.cas.cache.NullStatelessTicketCache;
import org.springframework.security.ui.WebAuthenticationDetails;
import org.springframework.security.ui.cas.ServiceProperties;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsChecker;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.checker.AccountStatusUserDetailsChecker;
import org.springframework.util.Assert;

public class EgovCasAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog(EgovCasAuthenticationProvider.class);
    private UserDetailsService userDetailsService;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private StatelessTicketCache statelessTicketCache = new NullStatelessTicketCache();
    private String key;
    private TicketValidator ticketValidator;
    private ServiceProperties serviceProperties;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"A userDetailsService must be set");
        Assert.notNull((Object)this.ticketValidator, (String)"A ticketValidator must be set");
        Assert.notNull((Object)this.statelessTicketCache, (String)"A statelessTicketCache must be set");
        Assert.hasText((String)this.key, (String)"A Key is required so CasAuthenticationProvider can identify tokens it previously authenticated");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
        Assert.notNull((Object)this.serviceProperties, (String)"serviceProperties is a required field.");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (authentication instanceof UsernamePasswordAuthenticationToken && !"_cas_stateful_".equals(authentication.getPrincipal().toString()) && !"_cas_stateless_".equals(authentication.getPrincipal().toString())) {
            return null;
        }
        if (authentication instanceof CasAuthenticationToken) {
            if (this.key.hashCode() == ((CasAuthenticationToken)authentication).getKeyHash()) {
                return authentication;
            }
            throw new BadCredentialsException(this.messages.getMessage("CasAuthenticationProvider.incorrectKey", "The presented CasAuthenticationToken does not contain the expected key"));
        }
        if (authentication.getCredentials() == null || "".equals(authentication.getCredentials())) {
            throw new BadCredentialsException(this.messages.getMessage("CasAuthenticationProvider.noServiceTicket", "Failed to provide a CAS service ticket to validate"));
        }
        boolean stateless = false;
        if (authentication instanceof UsernamePasswordAuthenticationToken && "_cas_stateless_".equals(authentication.getPrincipal())) {
            stateless = true;
        }
        CasAuthenticationToken result = null;
        if (stateless) {
            result = this.statelessTicketCache.getByTicketId(authentication.getCredentials().toString());
        }
        if (result == null) {
            result = this.authenticateNow(authentication);
            result.setDetails(authentication.getDetails());
        }
        if (stateless) {
            this.statelessTicketCache.putTicketInCache(result);
        }
        return result;
    }

    private final CasAuthenticationToken authenticateNow(Authentication authentication) throws AuthenticationException {
        try {
            String requestServerName = ((WebAuthenticationDetails)authentication.getDetails()).getRemoteAddress();
            EgovServiceProperties egovServiceProperties = (EgovServiceProperties)this.serviceProperties;
            Assertion assertion = this.ticketValidator.validate(authentication.getCredentials().toString(), egovServiceProperties.getServiceMap().containsKey(requestServerName) ? egovServiceProperties.getServiceByIp(requestServerName) : this.serviceProperties.getService());
            UserDetails userDetails = this.loadUserByAssertion(assertion);
            this.userDetailsChecker.check(userDetails);
            return new CasAuthenticationToken(this.key, (Object)userDetails, authentication.getCredentials(), userDetails.getAuthorities(), userDetails, assertion);
        }
        catch (TicketValidationException e) {
            throw new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
    }

    protected UserDetails loadUserByAssertion(Assertion assertion) {
        return this.userDetailsService.loadUserByUsername(assertion.getPrincipal().getName());
    }

    protected UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    protected String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public StatelessTicketCache getStatelessTicketCache() {
        return this.statelessTicketCache;
    }

    protected TicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setStatelessTicketCache(StatelessTicketCache statelessTicketCache) {
        this.statelessTicketCache = statelessTicketCache;
    }

    public void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public boolean supports(Class authentication) {
        if (UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication)) {
            return true;
        }
        return CasAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

