package com.gtis.sp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.sp.impl.SmsSenderException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 13-9-24
 */
public class HttpSmsSenderImpl implements SmsSender {
    private HttpClient httpClient;
    private String spUrl;

    public void setSpUrl(String spUrl) {
        this.spUrl = spUrl;
    }

    public HttpSmsSenderImpl() {
        HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
        connectionManager.getParams().setConnectionTimeout(10000);
        connectionManager.getParams().setSoTimeout(10000);
        httpClient = new HttpClient(connectionManager);
    }

    public void send(Date sendAt, String body, Collection<String> mobiles) throws SmsSenderException {
        if (StringUtils.isBlank(body) || CollectionUtils.isEmpty(mobiles)) {
            return;
        }
        PostMethod filePost = new PostMethod(spUrl);
        filePost.getParams().setContentCharset("UTF-8");
        filePost.addParameter("text", body.trim());
        if (sendAt != null) {
            filePost.addParameter("sendAt", DateFormatUtils.ISO_DATETIME_FORMAT.format(sendAt));
        }
        filePost.addParameter("mobile", StringUtils.join(mobiles, ","));
        try {
            httpClient.executeMethod(filePost);
            StringWriter sw = new StringWriter();
            IOUtils.copy(filePost.getResponseBodyAsStream(), sw, "UTF-8");
            JSONObject json = JSON.parseObject(sw.toString());
            if (!json.getBooleanValue("ret")) {
                throw new SmsSenderException(json.getString("msg"));
            }
        } catch (IOException e) {
            throw new SmsSenderException("Sms send fail", e);
        }
    }

    public static void main(String[] args) {
        HttpSmsSenderImpl hs=new HttpSmsSenderImpl();
        hs.httpClient=new HttpClient() ;
        hs.spUrl="http://sp.gtmap.cn/api/send?name=DEFAULT&password=gtmapinfo";
        hs.send(null,"中文短信", Collections.singletonList("18114465116"));
    }
}
