/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: NodeImpl.java
 *
 * LastModified: 2009-09-22 01:59:46
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */
package com.gtis.fileCenter.model.impl;

import com.gtis.fileCenter.Constants;
import com.gtis.fileCenter.model.Node;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 10/13/11
 */
public class NodeImpl implements Node {

    private static final long serialVersionUID = 888300615574833294L;

    private Integer id;
    private Integer parentId;
    private int type = TYPE_NODE;
    private int scope = SCOPE_DEFAULT;
    private String owner;
    private String name;
    private String viewName;
    private String icon;
    private String path;
    private Map<String, String> attributes;
    private String description;
    private Date updateTime;

    private transient Map<String, NodeImpl> children;
    private Integer childCount;
    private boolean writeable = false;
    //private byte[] fileContent;
    private String iconSkin;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getParentId() {
        return parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getScope() {
        return scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getViewName() {
        return viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map<String, String> getAttributes() {
        return attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setAttribute(String key, String value) {
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        attributes.put(key, value);
    }

    public String getAttribute(String key) {
        return getAttribute(key, null);
    }

    public String getAttribute(String key, String defaultValue) {
        String value = null;
        if (attributes != null) {
            value = attributes.get(key);
        }
        return value == null ? defaultValue : value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public List<Node> getChildren() {
        if (children == null)
            return null;
        List<Node> nodes = new ArrayList<Node>(children.size());
        for (Node n : children.values()) {
            try {
                nodes.add(n.clone());
            } catch (CloneNotSupportedException ignored) {
            }
        }
        Collections.sort(nodes);
        return nodes;
    }

    public void setChildren(List<Node> nodes) {
        if (nodes == null) {
            children = null;
            childCount = 0;
            return;
        }
        children = new LinkedHashMap<String, NodeImpl>(nodes.size());
        for (Node node : nodes) {
            children.put(node.getName(), (NodeImpl) node);
        }
        childCount = nodes.size();
    }

    public boolean isChildrenUnSet() {
        return children == null;
    }

    public NodeImpl getChild(String name) {
        if (children != null) {
            return children.get(name);
        }
        return null;
    }

    public void addChild(Node node) {
        if (children != null) {
            children.put(node.getName(), (NodeImpl) node);
            childCount++;
        }
    }

    public void removeChild(String name) {
        if (children != null && children.containsKey(name)) {
            children.remove(name);
            childCount--;
        }
    }

    public Integer getChildCount() {
        return childCount;
    }

    public void setChildCount(Integer childCount) {
        this.childCount = childCount;
    }

    public boolean isWriteable() {
        return writeable;
    }

    public void setWriteable(boolean writeable) {
        this.writeable = writeable;
    }

    public String getFullPath() {
        return getPath() + getId() + Constants.SEPARATOR;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        int code = 0;
        if (parentId != null) {
            code = parentId;
        }
        if (name != null) {
            code = code * 31 + name.hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        Node n = (Node) o;
        return id != null && id.equals(n.getId());
    }

    @Override
    public Node clone() throws CloneNotSupportedException {
        return (Node) super.clone();
    }

    public int compareTo(Node o) {
        int ret = getType() - o.getType();
        return ret == 0 ? getName().compareTo(o.getName()) : ret;
    }

    /*public byte[] getFileContent() {
        return fileContent;
    }

    public void setFileContent(byte[] fileContent) {
        this.fileContent = fileContent;
    }*/

    public String getIconSkin() {
        return iconSkin;
    }

    public void setIconSkin(String iconSkin) {
        this.iconSkin = iconSkin;
    }
}
