/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: Node.java
 *
 * LastModified: 2009-09-22 01:59:46
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * 文件中心节点类.
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-15
 */
public interface Node extends Serializable, Cloneable, Comparable<Node> {

    public static final int TYPE_ROOT = -1;
    public static final int TYPE_PERSONAL_ROOT = -2;
    public static final int TYPE_WORK_ROOT = -3;
    public static final int TYPE_NODE = 0;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_WORK_SPACE = 2;
    public static final int TYPE_PERSONAL_SPACE = 3;

    /**
     * 默认,都可访问
     */
    public static final int SCOPE_DEFAULT = 0;
    /**
     * 需要token才可访问
     */
    public static final int SCOPE_TOKEN = 1;

    public static final int PERM_READ = 0;
    public static final int PERM_WRITE = 1;

    /**
     * 获取节点Id
     *
     * @return 节点id
     */
    Integer getId();

    /**
     * 获取父节点id
     *
     * @return 父节点id
     */
    Integer getParentId();

    /**
     * 获取节点类型
     *
     * @return 类型
     */
    int getType();

    /**
     * 设置节点的共享类型
     *
     * @return
     */
    int getScope();

    /**
     * @param shareType
     */
    void setScope(int shareType);

    /**
     * 获取所有者
     *
     * @return 所有者id
     */
    String getOwner();

    /**
     * 设置所有者
     *
     * @param owner 所有者id
     */
    void setOwner(String owner);

    /**
     * 获取名称
     *
     * @return 名称
     */
    String getName();

    /**
     * 设置名称
     *
     * @param name 名称
     */
    void setName(String name);

    /**
     * 获取显示名
     *
     * @return 显示名
     */
    String getViewName();

    /**
     * 设置显示名
     *
     * @param viewName 显示名
     */
    void setViewName(String viewName);

    /**
     * 获取图标
     *
     * @return 图标
     */
    String getIcon();

    /**
     * 获取节点由父节点id组成的路径
     *
     * @return 路径
     */
    public String getPath();

    /**
     * 获取所有属性
     *
     * @return 所有属性
     */
    Map<String, String> getAttributes();

    /**
     * 设置属性
     *
     * @param key   属性key
     * @param value 属性值
     */
    void setAttribute(String key, String value);

    /**
     * 获取属性
     *
     * @param key 属性key
     * @return 属性值
     */
    String getAttribute(String key);

    /**
     * 获取属性
     *
     * @param key          属性key
     * @param defaultValue 默认值
     * @return 属性值
     */
    String getAttribute(String key, String defaultValue);

    /**
     * 获取节点说明
     *
     * @return 说明
     */
    String getDescription();

    /**
     * 设置节点说明
     *
     * @param description 说明
     */
    void setDescription(String description);

    /**
     * 获取更新时间
     *
     * @return 更新时间
     */
    Date getUpdateTime();

    /**
     * 设置更新时间
     *
     * @param updateTime 更新时间
     */
    void setUpdateTime(Date updateTime);

    /**
     * 获取子节点个数
     *
     * @return 子节点个数
     */
    Integer getChildCount();

    /**
     * 节点能否修改
     *
     * @return 能否修改
     */
    boolean isWriteable();


    Node clone() throws CloneNotSupportedException;

    /*public byte[] getFileContent();*/
}
