package com.gtis.exchange.service;

import com.gtis.exchange.vo.ReceiverVo;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 新交换系统服务封装接口
 *
 * @author <a href="mailto:xuexing3212@sina.com">zx</a>
 * @version V1.0, 2010-2-24
 */
public interface INewExchangeServeice {


    /**
     * 根据key获得待收文件总数
     *
     * @return
     * @params key
     */
    int getRecievedDataCount4Ready(String key);


    /**
     * 根据key收文的详细信息
     * @param taskId
     * @param ident
     * @param key
     * @return
     */
    public String getRecievedData(String taskId, String ident, String key) ;


    /**
     * 根据taskId,ident下载文件
     *
     * @param taskId
     * @param ident
     * @param key
     * @return
     */
    String downloadTaskFile(String taskId, String ident, String key);
    /**
     * 根据key拒收
     * @param taskId
     * @param ident
     * @param note
     * @param key
     * @throws Exception
     */
    public String refuseArchive(String taskId, String ident, String note, String key)throws Exception;

    /**
     * 发送公文
     *
     * @param unitNos
     * @param receiverVo
     * @param nodeId
     * @param key
     * @return
     * @throws Exception
     */
    String uploadFile(String[] unitNos, ReceiverVo receiverVo, Integer nodeId, String key) throws Exception;


    /**
     * 根据key根据条件查询收文记录总数
     *
     * @param params 查询条件，
     * @param key
     * @return
     */
    int getRecievedDataCount(Map params, String key);


    /**
     * 根据key根据条件查询收文列表信息
     *
     * @param params
     * @param pageIndex
     * @param pageSize
     * @return
     */
    String getRecievedDataXml(Map params, int pageIndex, int pageSize, String key);

    /**
     * 根据key和文件名文件路径下载文件。
     * @param taskId
     * @param fileName
     * @param filePath
     * @param fileType  文件类型(att-附件，doc-正文，ceb-CEB文件，pak-文件包，空则为att)
     * @param key
     * @param response
     * @return
     */
    public String downloadFile(String fileName, String filePath, String realName, String fileType, String taskId, String key,HttpServletResponse response);

    /**
     * 发送公文
     * @param fileName
     * @param orgList
     * @param key
     * @return
     */
    public String uploadFile(String fileName, String orgList, String key);

    /**
     * 解码
     * @param xml
     * @return
     */
    public String UrlDecode(String xml);
    /**
     * 获取部门结构列表
     * @param key
     * @param key
     * @return
     */
    public String getOrganList(String key);

    /**
     * 获取详细用户信息
     * @param userID
     * @param key
     * @return
     */
    public String getDetUserInfo(String userID, String key);

    /**
     * 获取部门信息，传orgID查询出orgName，传orgName查询orgID
     * @param orgID
     * @param orgName
     * @param key
     * @return
     */
    public String getOrganInfo(String orgID, String orgName, String key);
    /**
     * 获取用户信息，传userID查询出username，传username查询userID
     * @param userID
     * @param userName
     * @param key
     * @return
     */
    public String getUserInfo(String userID, String userName, String key);

    /**
     * 根据key接收收文
     * @param taskId
     * @param ident
     * @param key
     * @throws Exception
     */
    public String receptionArchive(String taskId, String ident, String key)throws Exception;
}
