package com.gtis.common;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-8-10
 */
public class Page<T> implements Serializable {

    public static final int ALL = -1;
    public static final int SHOW_PAGES = 8;
    public static final int DEFAULT_SIZE = 20;
    private static final long serialVersionUID = 399508739687121397L;
    protected int totalCount = 0;
    protected List<T> items = Collections.emptyList();
    private int index = 1;
    private int size = DEFAULT_SIZE;

    public Page() {
    }

    public Page(int index) {
        this.index = index;
    }

    public Page(List<T> items) {
        this.items = items;
    }

    public Page(int index, int size) {
        this(index);
        this.size = size;
    }

    @JSONField(serialize = false)
    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List<T> getItems() {
        return items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public T getItem(int index) {
        return items.get(index);
    }

    @JSONField(serialize = false)
    public List<Integer> getShowPages() {
        List<Integer> pages = new ArrayList<Integer>();
        int start = index - SHOW_PAGES;
        int end = index + SHOW_PAGES;
        int total = getPageCount();
        start = start > 0 ? start : 1;
        end = end > total ? total : end;
        for (int i = start; i <= end; i++) {
            pages.add(i);
        }
        return pages;
    }

    @JSONField(serialize = false)
    public int getPageCount() {
        int count = totalCount / size;
        return totalCount % size != 0 ? count + 1 : count;
    }

    public void setStart(int start) {
        this.index = toIndex(start, size);
    }

    @JSONField(serialize = false)
    public boolean isEmpty() {
        return totalCount == 0;
    }

    public static int toIndex(int start, int size) {
        return start / size + 1;
    }

    public static int toStart(Integer index, int size) {
        if (index == null)
            return 0;
        return (index - 1) * size;
    }
}
