/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Dot;
import freemarker.core.DynamicKeyName;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.FMParser;
import freemarker.core.FMParserTokenManager;
import freemarker.core.Identifier;
import freemarker.core.Macro;
import freemarker.core.ParseException;
import freemarker.core.SimpleCharStream;
import freemarker.log.Logger;
import freemarker.sweet.BeanUtils;
import freemarker.sweet.DefaultTemplateModelWrapper;
import freemarker.sweet.DirectiveHelper;
import freemarker.sweet.ModifiableTemplateModel;
import freemarker.sweet.TemplateModelWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ParamDirective
implements TemplateDirectiveModel {
    private static final ConcurrentMap<String, Expression> expsCache = new ConcurrentHashMap<String, Expression>();
    private static final Logger logger = Logger.getLogger((String)ParamDirective.class.getName());
    private static TemplateModelWrapper templateModelWrapper = DefaultTemplateModelWrapper.getDefaultInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String name = DirectiveHelper.getRequiredParam(params, "name");
        Action action = Action.set;
        try {
            action = Action.valueOf(DirectiveHelper.getParam(params, "action", "set"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TemplateModel value = (TemplateModel)params.get("value");
        if (value == null && body != null) {
            StringWriter sw = new StringWriter();
            body.render((Writer)sw);
            value = new SimpleScalar(sw.toString());
        }
        Macro.Context mc = (Macro.Context)DirectiveHelper.getMacroContext(env);
        Macro.Context invokingMacroContext = env.getCurrentMacroContext();
        try {
            BeanUtils.setValue(env, "currentMacroContext", mc);
            Expression exp = ParamDirective.getExpression(name, env.getTemplate());
            TemplateModel tm = null;
            Object var12_14 = null;
            if (action.equals((Object)Action.add) || action.equals((Object)Action.addAll) || action.equals((Object)Action.clear)) {
                tm = exp.getAsTemplateModel(env);
            } else if (exp instanceof Identifier) {
                String string = exp.toString();
                tm = mc == null ? env.getCurrentNamespace() : mc.getLocals();
            } else if (exp instanceof Dot || exp instanceof DynamicKeyName) {
                Expression target = (Expression)BeanUtils.getValue((Object)exp, "target");
                if (target != null) {
                    tm = target.getAsTemplateModel(env);
                }
                if (exp instanceof Dot) {
                    Object t = BeanUtils.getValue((Object)exp, "key");
                } else {
                    Expression nameExpression = (Expression)BeanUtils.getValue((Object)exp, "nameExpression");
                    if (nameExpression != null) {
                        TemplateModel templateModel = nameExpression.getAsTemplateModel(env);
                    }
                }
            }
            if (tm == null) {
                logger.warn("expression class [" + exp.getClass() + "] are not support,only Identifier,Dot,DynamicKeyName can be use");
                return;
            }
            ModifiableTemplateModel mtm = templateModelWrapper.wrap(tm);
            if (mtm == null) {
                logger.warn("expression class [" + exp.getClass() + "] are not support");
            }
            mtm.setBeansWrapper(env.getObjectWrapper());
            switch (action) {
                case add: {
                    mtm.add(value);
                    return;
                }
                case addAll: {
                    mtm.addAll(value);
                    return;
                }
                case set: {
                    void var12_18;
                    mtm.set(var12_18, value);
                    return;
                }
                case remove: {
                    void var12_18;
                    mtm.remove(var12_18);
                    return;
                }
                case clear: {
                    mtm.clear();
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            logger.error("save param [" + name + "] value [" + value + "] error", (Throwable)e);
            return;
        }
        finally {
            BeanUtils.setValue(env, "currentMacroContext", invokingMacroContext);
        }
    }

    public static Expression getExpression(String source, Template template) throws ParseException {
        Expression exp = (Expression)expsCache.get(source);
        if (exp == null) {
            FMParserTokenManager tokenSource = new FMParserTokenManager(new SimpleCharStream((Reader)new StringReader(source)));
            tokenSource.SwitchTo(2);
            FMParser parser = new FMParser(tokenSource);
            parser.setTemplate(template);
            exp = parser.Expression();
            expsCache.put(source, exp);
        }
        return exp;
    }

    public static enum Action {
        add,
        addAll,
        set,
        remove,
        clear;

    }
}

