/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.ibatis;

import com.gtis.ibatis.CountStatementUtil;
import com.gtis.ibatis.OrderByStatementUtil;
import com.gtis.ibatis.SplitSqlExecutor;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

public abstract class BaseDaoiBatisSupport
implements InitializingBean {
    private SqlExecutor sqlExecutor;
    protected Log log = LogFactory.getLog(this.getClass());
    private SqlMapClientTemplate sqlMapClientTemplate = new SqlMapClientTemplate();

    public SqlMapClientTemplate getSqlMapClientTemplate() {
        return this.sqlMapClientTemplate;
    }

    public void setDataSource(DataSource dataSource) {
        this.sqlMapClientTemplate.setDataSource(dataSource);
    }

    @Autowired
    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClientTemplate.setSqlMapClient(sqlMapClient);
    }

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public void setSqlExecutor(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        SqlMapClientImpl client = (SqlMapClientImpl)this.getSqlMapClientTemplate().getSqlMapClient();
        SqlMapExecutorDelegate delegate = client.getDelegate();
        try {
            ReflectUtil.setFieldValue(delegate, "sqlExecutor", SqlExecutor.class, this.sqlExecutor);
            this.log.info((Object)("[iBATIS] success set ibatis SqlMapClient.sqlExecutor = " + this.sqlExecutor.getClass().getName()));
        }
        catch (Exception e) {
            this.log.info((Object)("[iBATIS] error,cannot set ibatis SqlMapClient.sqlExecutor = " + this.sqlExecutor.getClass().getName() + " cause:" + e));
        }
    }

    public void setEnableLimit(boolean enableLimit) {
        if (this.sqlExecutor instanceof SplitSqlExecutor) {
            ((SplitSqlExecutor)this.sqlExecutor).setEnableLimit(enableLimit);
        }
    }

    public List queryForListOrderby(String selectQuery, Object parameterObject, int skipSize, int pageSize) {
        String orderByQuery = OrderByStatementUtil.getOrderByStatementId(selectQuery);
        SqlMapClient sqlMapClient = this.getSqlMapClientTemplate().getSqlMapClient();
        if (sqlMapClient instanceof ExtendedSqlMapClient) {
            SqlMapExecutorDelegate delegate = ((ExtendedSqlMapClient)sqlMapClient).getDelegate();
            try {
                delegate.getMappedStatement(orderByQuery);
            }
            catch (SqlMapException e) {
                delegate.addMappedStatement(OrderByStatementUtil.createOrderByStatement(delegate.getMappedStatement(selectQuery)));
            }
        }
        return this.getSqlMapClientTemplate().queryForList(OrderByStatementUtil.getOrderByStatementId(selectQuery), parameterObject, skipSize, pageSize);
    }

    public int getObjectTotal(String selectQuery, Object parameterObject) {
        this.prepareCountQuery(selectQuery);
        return Integer.parseInt(this.getSqlMapClientTemplate().queryForObject(CountStatementUtil.getCountStatementId(selectQuery), parameterObject).toString());
    }

    protected void prepareCountQuery(String selectQuery) {
        SqlMapClient sqlMapClient;
        String countQuery = CountStatementUtil.getCountStatementId(selectQuery);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Convert " + selectQuery + " to " + countQuery));
        }
        if ((sqlMapClient = this.getSqlMapClientTemplate().getSqlMapClient()) instanceof ExtendedSqlMapClient) {
            SqlMapExecutorDelegate delegate = ((ExtendedSqlMapClient)sqlMapClient).getDelegate();
            try {
                delegate.getMappedStatement(countQuery);
            }
            catch (SqlMapException e) {
                delegate.addMappedStatement(CountStatementUtil.createCountStatement(delegate.getMappedStatement(selectQuery)));
            }
        }
    }

    static class ReflectUtil {
        private static final Log logger = LogFactory.getLog(ReflectUtil.class);

        ReflectUtil() {
        }

        public static void setFieldValue(Object target, String fname, Class ftype, Object fvalue) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
            if (target == null || fname == null || "".equals(fname) || fvalue != null && !ftype.isAssignableFrom(fvalue.getClass())) {
                return;
            }
            Class<?> clazz = target.getClass();
            try {
                Method method = clazz.getDeclaredMethod("set" + Character.toUpperCase(fname.charAt(0)) + fname.substring(1), ftype);
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                method.invoke(target, fvalue);
            }
            catch (Exception me) {
                Field field = clazz.getDeclaredField(fname);
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                field.set(target, fvalue);
            }
        }
    }
}

