/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.generic.image.impl;

import com.gtis.generic.image.ImageTransform;
import com.gtis.generic.image.impl.AwtImageTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagickCommandImageTransform
implements ImageTransform {
    private static final Logger logger = LoggerFactory.getLogger(AwtImageTransform.class);
    private String srcFilePath;
    private double srcWidth;
    private double srcHeight;
    private double destRotate = 0.0;
    private double destRatio = 1.0;
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1;

    @Override
    public boolean load(String srcFilePath) {
        try {
            BufferedImage srcBImage = ImageIO.read(new File(srcFilePath));
            this.srcFilePath = srcFilePath;
            this.srcWidth = srcBImage.getWidth();
            this.srcHeight = srcBImage.getHeight();
        }
        catch (IOException e) {
            logger.info("Cannot open image [{}]", (Object)srcFilePath);
            return false;
        }
        return true;
    }

    @Override
    public boolean save(String destFilePath) {
        StringBuffer cmd = new StringBuffer();
        if (isWindows) {
            cmd.append("cmd /c ");
        }
        cmd.append("convert ");
        if (this.destRotate != 0.0) {
            cmd.append("-rotate ").append(this.destRotate).append(" ");
        }
        if (this.destRatio != 1.0) {
            cmd.append("-sample ").append(this.destRatio * this.srcWidth).append("x").append(this.destRatio * this.srcHeight).append(" ");
        }
        cmd.append(this.srcFilePath).append(" ").append(destFilePath);
        logger.debug(cmd.toString());
        try {
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            int exitVal = proc.waitFor();
            if (exitVal != 0) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("Error exec magick convert command [" + cmd + "]", (Throwable)e);
        }
        return true;
    }

    @Override
    public void resize(int width, int height) throws Exception {
        double xRatio = (double)height / this.srcHeight;
        double yRatio = (double)width / this.srcWidth;
        this.destRatio = xRatio < yRatio ? xRatio : yRatio;
    }

    @Override
    public void rotate(double rotate) throws Exception {
        this.destRotate = rotate;
    }

    @Override
    public void resizeWithMaxWidth(int maxWidth) throws Exception {
        if (this.srcWidth > (double)maxWidth) {
            this.destRatio = (double)maxWidth / this.srcWidth;
        }
    }

    @Override
    public void rotateWithMaxWidth(double rotate, int maxWidth) throws Exception {
        this.rotate(rotate);
        this.resizeWithMaxWidth(maxWidth);
    }
}

