/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.fileCenter.CustomFilePart;
import com.gtis.fileCenter.ex.NodeExistsException;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Downloader;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.FileService;
import com.gtis.fileCenter.service.NodeService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class FileServiceImpl
implements FileService {
    private static final Logger logger = LoggerFactory.getLogger(FileServiceImpl.class);
    private NodeService nodeService;
    private String fileCenterUrl;
    private HttpClient httpClient;

    public FileServiceImpl() {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
        connectionManager.getParams().setConnectionTimeout(10000);
        connectionManager.getParams().setSoTimeout(10000);
        this.httpClient = new HttpClient((HttpConnectionManager)connectionManager);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public String getFileCenterUrl() {
        return this.fileCenterUrl;
    }

    public void setFileCenterUrl(String fileCenterUrl) {
        this.fileCenterUrl = fileCenterUrl;
    }

    @Override
    public Node uploadFile(File file, Integer parentId) throws NodeNotFoundException, NodeExistsException, IOException {
        return this.uploadFile(file, parentId, null);
    }

    @Override
    public Node uploadFile(File file, Integer parentId, String name) throws NodeNotFoundException, NodeExistsException, IOException {
        return this.uploadFile(file, parentId, name, null, false, true);
    }

    @Override
    public Node uploadFile(InputStream is, Integer parentId, String name) throws NodeNotFoundException, NodeExistsException, IOException {
        return this.uploadFile(is, parentId, name, null, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node uploadFile(InputStream is, Integer parentId, String name, String path, boolean cover, boolean rename) throws NodeNotFoundException, NodeExistsException, IOException {
        Assert.notNull((Object)name);
        File tempFile = null;
        try {
            tempFile = File.createTempFile("fileCenter", null);
            FileCopyUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(tempFile));
            Node node = this.uploadFile(tempFile, parentId, name, path, cover, rename);
            return node;
        }
        catch (IOException e) {
            logger.error("error to upload:" + name, (Throwable)e);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        return null;
    }

    @Override
    public Node uploadFile(File file, Integer parentId, String name, String path, boolean cover, boolean rename) throws NodeNotFoundException, NodeExistsException, IOException {
        Node node = this.nodeService.getNode(parentId, path, true);
        PostMethod filePost = new PostMethod(this.fileCenterUrl + "/file/upload.do");
        if (name == null) {
            name = file.getName();
        }
        Integer node_id = parentId;
        if (path != null) {
            node_id = node.getId();
        }
        Part[] parts = new Part[]{new StringPart("nid", node_id.toString()), new StringPart("token", this.nodeService.getToken(node)), new StringPart("cover", Boolean.toString(cover)), new StringPart("rename", Boolean.toString(rename)), new CustomFilePart(name, name, file)};
        filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
        HttpClient client = new HttpClient();
        client.executeMethod((HttpMethod)filePost);
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)filePost.getResponseBodyAsStream(), (Writer)sw, (String)"UTF-8");
        JSONObject json = JSON.parseObject((String)sw.toString());
        int code = json.getInteger("type");
        switch (code) {
            case 0: {
                return this.nodeService.getNode(json.getJSONObject("file").getInteger("id"));
            }
            case 1: {
                throw new NodeNotFoundException(parentId, name);
            }
            case 2: {
                throw new NodeExistsException(parentId, name);
            }
        }
        throw new IOException("upload file " + file.getAbsolutePath() + " to nodeId " + parentId + " error,msg:[" + json.getString("msg") + "]");
    }

    @Override
    public void download(Integer nodeId, Downloader downloader) throws NodeNotFoundException, IOException {
        this.download(nodeId, null, downloader);
    }

    @Override
    public void download(Integer nodeId, String path, Downloader downloader) throws NodeNotFoundException, IOException {
        Node node = this.nodeService.getNode(nodeId, path);
        StringBuilder sb = new StringBuilder(this.fileCenterUrl);
        sb.append("/file/get.do?fid=");
        sb.append(node.getId());
        if (node.getScope() != 0) {
            sb.append("&token=").append(this.nodeService.getToken(node));
        }
        GetMethod get = new GetMethod(sb.toString());
        InputStream is = null;
        try {
            if (this.httpClient.executeMethod((HttpMethod)get) != 200) {
                throw new NodeNotFoundException(nodeId, "run http get error");
            }
            is = get.getResponseBodyAsStream();
            downloader.download(is, node);
        }
        catch (IOException e) {
            throw new NodeNotFoundException(nodeId, "run http get error");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            get.releaseConnection();
        }
    }

    @Override
    public void downloadToFile(Integer nodeId, String savePath) throws NodeNotFoundException, IOException {
        this.downloadToFile(nodeId, null, savePath);
    }

    @Override
    public void downloadToFile(final Integer nodeId, String path, final String savePath) throws NodeNotFoundException, IOException {
        this.download(nodeId, path, new Downloader(){

            @Override
            public void download(InputStream is, Node node) {
                File file = new File(savePath);
                File pFile = file.getParentFile();
                if (!pFile.exists()) {
                    pFile.mkdirs();
                }
                try {
                    FileCopyUtils.copy((InputStream)is, (OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
                }
                catch (IOException e) {
                    throw new NodeNotFoundException(nodeId, "save to path:" + savePath + " error");
                }
            }
        });
    }
}

