/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.config;

import com.gtis.config.ConfigPlaceholderResolver;
import com.gtis.config.EncryptHelper;
import com.gtis.config.PropertyPlaceholderHelper;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderSupport;
import org.springframework.util.ClassUtils;

public class EgovConfigLoader
extends PropertiesLoaderSupport {
    protected final Log logger = LogFactory.getLog(EgovConfigLoader.class);
    private static final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ":", true);
    public static final String HOME_NAME = "egov.home";
    public static final String CONF_NAME = "egov.conf";
    public static final String DATA_NAME = "egov.data";
    public static final String PROPERTY_FILE_NAME = "egov.properties";
    public static final String DEFAULT_ACTIVE_CONF = "default";
    public static final String EGOV_HOME_FOLDER = "egov-home";

    public static void load(String ... paths) {
        EgovConfigLoader cl = new EgovConfigLoader();
        cl.loadConfig(paths);
    }

    public void loadConfig(String ... paths) {
        File home;
        String configHome = this.getConfigProperty(HOME_NAME);
        if (configHome != null) {
            this.logger.info((Object)("Egov home has been set to [" + configHome + "],skip"));
            return;
        }
        File root = this.determineRootDir(paths);
        if (root != null) {
            this.logger.info((Object)("Use egov-home dir:[" + root + "]"));
            File activeFile = new File(root, "active.conf");
            String active = DEFAULT_ACTIVE_CONF;
            try {
                active = FileUtils.readFileToString((File)activeFile);
            }
            catch (IOException e) {
                this.logger.info((Object)("Read active profile from [" + activeFile.getAbsolutePath() + "] fail,use default"));
            }
            home = new File(root, active);
            if (!home.exists() && !(home = new File(root, DEFAULT_ACTIVE_CONF)).exists()) {
                this.logger.error((Object)("Egov active conf [" + home.getAbsoluteFile() + "] not exsit"));
            }
            this.logger.info((Object)("Use Custom config home dir:[" + home + "]"));
        } else {
            home = new File("/opt/gtis/config/egov/default");
            if (home.exists()) {
                this.logger.warn((Object)("Use compact config home dir:[" + home.getAbsolutePath() + "],please convert to new format"));
                this.setConfigProperty(HOME_NAME, new File("/opt/gtis"));
                this.setConfigProperty(CONF_NAME, home);
                this.setConfigProperty(DATA_NAME, new File("/opt/gtis/data"));
                this.loadProperties(new File(home, PROPERTY_FILE_NAME));
                return;
            }
            String location = "META-INF/conf/egov.properties";
            ClassPathResource resource = new ClassPathResource(location, ClassUtils.getDefaultClassLoader());
            URL url = null;
            try {
                url = resource.getURL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (url != null) {
                try {
                    home = new File(url.toURI()).getParentFile().getParentFile();
                    this.logger.info((Object)("Custom config home not found,Use classpath config home dir [" + home.getAbsolutePath() + "]"));
                }
                catch (URISyntaxException ignored) {
                    return;
                }
            } else {
                this.logger.error((Object)"Load config error,config not found");
                return;
            }
        }
        String homePath = home.getAbsolutePath();
        String confPath = homePath + File.separator + "conf";
        this.setConfigProperty(HOME_NAME, home);
        this.setConfigProperty(CONF_NAME, new File(confPath));
        if (this.getConfigProperty(DATA_NAME) == null) {
            this.setConfigProperty(DATA_NAME, new File(homePath + File.separator + "data"));
        }
        this.loadProperties(new File(confPath, PROPERTY_FILE_NAME));
    }

    private void loadProperties(File file) {
        this.setLocation((Resource)new FileSystemResource(file));
        try {
            Properties props = this.mergeProperties();
            ConfigPlaceholderResolver resolver = new ConfigPlaceholderResolver(props);
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = props.getProperty(name);
                value = helper.replacePlaceholders(value, resolver);
                this.setConfigProperty(name, helper.replacePlaceholders(value, resolver));
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("error to load props file:[" + file.getAbsolutePath() + "]"), (Throwable)e);
        }
    }

    protected Properties mergeProperties() throws IOException {
        Properties props = super.mergeProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String v = (String)entry.getValue();
            if (v == null || !v.startsWith("!!")) continue;
            entry.setValue(EncryptHelper.decrypt(v));
        }
        return props;
    }

    protected void setConfigProperty(String key, File file) {
        this.setConfigProperty(key, file.toURI().toString());
        this.setConfigProperty(key + ".path", file.getAbsolutePath());
        this.logger.info((Object)("Use " + key + " dir:[" + file.getAbsolutePath() + "]"));
    }

    protected void setConfigProperty(String key, String value) {
        this.logger.debug((Object)("Set config property [" + key + "=" + value + "]"));
        System.setProperty(key, value);
    }

    protected String getConfigProperty(String key) {
        return System.getProperty(key);
    }

    private File determineRootDir(String ... paths) {
        File root;
        if (paths != null) {
            for (String path : paths) {
                root = new File(path);
                if (!root.exists()) continue;
                return root;
            }
        }
        for (String path : new String[]{System.getProperty("EGOV_HOME"), System.getenv("EGOV_HOME")}) {
            if (path == null || !(root = new File(path)).exists()) continue;
            return root;
        }
        for (String path : new String[]{System.getProperty("catalina.base"), System.getProperty("catalina.home"), System.getProperty("user.home")}) {
            if (path == null || !(root = new File(path, EGOV_HOME_FOLDER)).exists()) continue;
            return root;
        }
        return null;
    }
}

