/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.config;

import com.gtis.config.ConfigPlaceholderResolver;
import com.gtis.config.PropertyPlaceholderHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public final class AppConfig
implements InitializingBean {
    public static final String PLAT_FORM_URL = "platform.url";
    public static final String FILE_CENTER_URL = "fileCenter.url";
    public static final String CAS_URL = "cas.url";
    protected static final Log logger = LogFactory.getLog(AppConfig.class);
    private static final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ":", true);
    private static ConfigPlaceholderResolver resolver = new ConfigPlaceholderResolver();
    private String[] necessaryConfigs;
    private static Map appProperties = new HashMap();

    public static void setConfiguration(Map properties) {
        appProperties = properties;
        resolver.setProps(appProperties);
    }

    public void setNecessaryConfigs(String[] necessaryConfigs) {
        this.necessaryConfigs = necessaryConfigs;
    }

    public static String getProperty(String key) {
        Assert.notNull((Object)key, (String)"Argument 'key' must not be null.");
        return resolver.resolvePlaceholder(key);
    }

    public static String getPlaceholderValue(String key) {
        Assert.notNull((Object)key, (String)"Argument 'key' must not be null.");
        return helper.replacePlaceholders(key, resolver);
    }

    public static int getIntProperty(String key) {
        return AppConfig.getIntProperty(key, 0);
    }

    public static int getIntProperty(String key, int defaultValue) {
        String property = AppConfig.getProperty(key);
        int value = defaultValue;
        try {
            value = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e.toString());
        }
        return value;
    }

    public static boolean getBooleanProperty(String key) {
        return AppConfig.getBooleanProperty(key, false);
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = AppConfig.getProperty(key);
        if (null != value) {
            return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
        }
        return defaultValue;
    }

    public static Map getProperties() {
        return appProperties;
    }

    public void afterPropertiesSet() throws Exception {
        String[] keys = this.necessaryConfigs;
        if (keys == null) {
            return;
        }
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            String key = StringUtils.trimToEmpty((String)keys[i]);
            if (appProperties.containsKey(key)) continue;
            throw new IllegalStateException("Can not find property \"" + key + "\" in configuration file.");
        }
    }

    public static String getPlatFormUrl() {
        return AppConfig.getProperty(PLAT_FORM_URL);
    }

    public static String getCasUrl() {
        return AppConfig.getProperty(CAS_URL);
    }

    public static String getFileCenterUrl() {
        return AppConfig.getProperty(FILE_CENTER_URL);
    }

    public static String getConfHome(String ... name) {
        return AppConfig.getProperty("egov.conf" + AppConfig.namesToPath(name));
    }

    public static String getDataHome(String ... name) {
        return AppConfig.getProperty("egov.data" + AppConfig.namesToPath(name));
    }

    public static String getEgovHome() {
        return AppConfig.getProperty("egov.home");
    }

    private static String namesToPath(String ... name) {
        if (name != null && name.length > 0) {
            return "/" + StringUtils.join((Object[])name, (String)"/");
        }
        return "";
    }
}

