package com.gtis.spring;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.springframework.remoting.httpinvoker.CommonsHttpInvokerRequestExecutor;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-12
 */
public class OptimizedHttpInvokerRequestExecutor extends CommonsHttpInvokerRequestExecutor {

    public OptimizedHttpInvokerRequestExecutor() {
        HttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = httpConnectionManager.getParams();
        params.setDefaultMaxConnectionsPerHost(32);
        params.setMaxTotalConnections(128);
        setHttpClient(new HttpClient(httpConnectionManager));
        this.setReadTimeout(30 * 1000);
    }
}
