package com.gtis.search;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-2-1
 */
public class MimeTypeHelper {

    public static final Set<String> IMAGE_POSTFIX = new HashSet<String>();
    public static final Set<String> DOCUMENT_POSTFIX = new HashSet<String>();

    static {
        Collections.addAll(IMAGE_POSTFIX, "gif", "bmp", "jpg", "jpeg", "png");
        Collections.addAll(DOCUMENT_POSTFIX, "doc", "docx", "xls", "xlsx", "ppt", "pptx", "pdf");
    }

    public static MimeType getMimeType(String fileName) {
        String ext = getExt(fileName);
        if (ext == null) {
            return MimeType.TEXT;
        } else if (IMAGE_POSTFIX.contains(ext)) {
            return MimeType.IMG;
        } else if (DOCUMENT_POSTFIX.contains(ext)) {
            return MimeType.DOC;
        } else {
            return MimeType.BIN;
        }
    }

    public static String getExt(String fileName) {
        if (fileName != null) {
            int index = fileName.lastIndexOf('.');
            if (index > -1 && (index < fileName.length() - 1)) {
                return fileName.substring(index + 1).toLowerCase();
            }
        }
        return null;
    }
}
