package com.gtis.search;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-10
 */
public abstract class AbstractIndexTemplateSupport {
    protected final Logger logger = LoggerFactory.getLogger(getClass());
    protected Map<String, Resource> tplRess = new HashMap<String, Resource>();

    public void setTplPaths(Map<String, Resource> ress) {
        tplRess.putAll(ress);
    }

    public void setTestUrlTplPath(Resource res) {
        tplRess.put(Constants.TPL_TEXT_URL, res);
    }

    public void setTextBodyTplPath(Resource res) {
        tplRess.put(Constants.TPL_TEXT_BODY, res);
    }

    public void setFileUrlTplPath(Resource res) {
        tplRess.put(Constants.TPL_FILE_URL, res);
    }

    public void setFileBodyTplPath(Resource res) {
        tplRess.put(Constants.TPL_FILE_BODY, res);
    }

    public void setTextUrlTplText(String text) {
        setTplText(Constants.TPL_TEXT_URL, text);
    }

    public void setTextBodyTplText(String text) {
        setTplText(Constants.TPL_TEXT_BODY, text);
    }

    public void setFileUrlTplText(String text) {
        setTplText(Constants.TPL_FILE_URL, text);
    }

    public void setFileBodyTplText(String text) {
        setTplText(Constants.TPL_FILE_BODY, text);
    }

    protected void reloadTpl() {
        if (tplRess == null)
            return;
        for (Map.Entry<String, Resource> entry : tplRess.entrySet()) {
            try {
                Resource res = entry.getValue();
                /**
                 * zdd 2016-06-01 部署weblogic下  new FileInputStream(res.getFile())存在问题。所以此处直接获取文件流
                 */
                InputStream inputStream = res.getInputStream();
                setTplText(entry.getKey(), IOUtils.toString(inputStream, Constants.DEFAULT_CHARSET));
            } catch (IOException e) {
                logger.error("Error to read template [" + entry.getValue().getDescription() + "]", e);
            }
        }
    }

    public abstract void setTplVars(Map<String, Serializable> vars);

    public abstract void setTplText(String name, String text);
}
