package com.gtis.plat.service;

import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import org.dom4j.Document;

import java.util.HashMap;
import java.util.List;

public interface WorkFlowCoreService {

    /**
     * 创建工作流
     *
     * @param intanceVo
     * @param userId    当前用户
     * @return
     */
    public WorkFlowInfo createWorkFlowInstance(PfWorkFlowInstanceVo intanceVo, String userId) throws Exception;

    /**
     * 获取任务的转发信息
     *
     * @return
     * @throws Exception
     */
    public WorkFlowInfo getWorkFlowTurnInfo(String userId, String taskId) throws Exception;

    /**
     * 获取工作流退回信息
     *
     * @param userId
     * @param taskId
     * @return
     * @throws Exception
     */
    public WorkFlowInfo getWorkFlowTurnBackInfo(String userId, String taskId) throws Exception;

    /**
     * 工作流转发
     *
     * @param userId
     * @param taskId
     * @param info
     * @return
     * @throws Exception
     */
    public boolean postWorkFlow(String userId, String taskId, WorkFlowInfo info) throws Exception;

    /**
     * 退回
     *
     * @param userId
     * @param taskId
     * @param backDefineActivitys
     * @param remark
     * @return
     * @throws Exception
     */
    public boolean postBackWorkFlow(String userId, String taskId, String[] backDefineActivitys, String remark) throws Exception;

    /**
     * 退回
     * 根据选择的人员进行退回，也就是支持退回给某个人
     * @param userId
     * @param taskId
     * @param selectAcMap 内部是map，完整的相当于{"adid":"users"}
     * @param remark
     * @return
     * @throws Exception
     */
    public boolean postBackWorkFlow(String userId, String taskId, HashMap<String,String> selectAcMap, String remark) throws Exception;

    /**
     * 删除工作流实例
     *
     * @param workflowIntanceId
     * @return
     * @throws Exception
     */
    public boolean deleteWorkFlowInstance(String userId, String workflowIntanceId) throws Exception;

    /**
     * 挂起工作流实例
     *
     * @param workflowIntanceId
     * @param param 扩展参数
     * @return
     * @throws Exception
     */
    public boolean overWorkFlowInstance(String workflowIntanceId, HashMap param) throws Exception;

    /**
     * 挂起工作流实例
     *
     * @param workflowIntanceId
     * @param taskId
     * @return
     * @throws Exception
     */
    public boolean lockWorkFlowInstance(String workflowIntanceId, String taskId) throws Exception;

    /**
     * 挂起工作流实例
     *
     * @param workflowIntanceId
     * @param taskId
     * @param reMark
     * @return
     * @throws Exception
     */
    public boolean lockWorkFlowInstance(String workflowIntanceId, String taskId, String reMark) throws Exception;

    /**
     * 挂起工作流实例并传userId
     *
     * @param workflowIntanceId
     * @param taskId
     * @param reMark
     * @param userId
     * @return
     * @throws Exception
     */
    public boolean lockWorkFlowInstance(String workflowIntanceId, String taskId, String reMark,String userId) throws Exception;
    /**
     * 解除挂起工作流实例
     *
     * @param workflowIntanceId
     * @return
     * @throws Exception
     */
    public boolean unLockWorkFlowInstance(String workflowIntanceId) throws Exception;

    /**
     * 工作流办结
     *
     * @param workflowIntanceId
     * @return
     * @throws Exception
     */
    public boolean finishWorkFlow(String workflowIntanceId) throws Exception;

    /**
     * 仅仅内部使用
     *
     * @param infoObj
     * @return
     * @throws Exception
     */
    public boolean finishWorkFlow(WorkFlowInfo infoObj) throws Exception;

    /**
     * 取回工作流
     *
     * @param taskId 已办任务id
     * @return
     * @throws Exception
     */
    public boolean retrieveWorkFlow(String userId, String taskId) throws Exception;

    /**
     * 重新办理工作流
     *
     * @param userId
     * @param wiid
     * @param remark
     * @return
     * @throws Exception
     */
    boolean restartWorkFlow(String userId, String wiid, String remark) throws Exception;

    /**
     * 工作流转发
     *
     * @param doc    工作流xml
     * @param taskId
     * @return
     * @throws Exception
     */
    boolean turnTask(Document doc, String taskId) throws Exception;

    /**
     * 工作流转发
     *
     * @param xml
     * @param taskId
     * @return
     * @throws Exception
     */
    boolean turnTask(String xml, String taskId, String userId) throws Exception;


    /**
     * 委托任务
     * @param taskId
     * @param trustUserId
     * @return
     * @throws Exception
     */
    boolean entrustTask(String taskId, String trustUserId) throws Exception;
}
