package com.gtis.plat.service;

import com.gtis.plat.vo.*;
import com.gtis.plat.wf.model.PerformerModel;

import java.util.List;

public interface SysUserService {

    /**
     * 根据用户名获取用户
     * @param userName
     * @return
     */
    public List<PfUserVo> getUserVoListByUserName(String userName);

    /**
     * 根据用户名获取用户，模糊查询
     * @param userName
     * @return
     */
    public List<PfUserVo> getUserVoListByUserNameFuzzy(String userName);

    /**
     * 根据用户ID，查找部门
     * @param userId
     * @return
     */
    public List<PfOrganVo> getOrganListByUser(String userId);

    /**
     * 根据用户ID，查找角色
     * @param userId
     * @return
     */
    public List<PfRoleVo> getRoleListByUser(String userId);

    /**
     * 根据登陆用户名，查找用户
     * @param loginName
     * @return
     */
    public PfUserVo getUserByloginName(String loginName);

    /**
     * 查找一个用户所有的角色集合
     * @param userId
     * @return
     */
    public List<String> getRoleListByAgentUser(String userId);

    /**
     * 查找一个部门下面所有的人员
     * @param oragnId
     * @return
     */
    public List<PfUserVo> getUserListByOragn(String oragnId);

    /**
     * 查找一个角色下面所有的人员
     * @param roleId
     * @return
     */
    public List<PfUserVo> getUserListByRole(String roleId);

    /**
     * 查找一个人员
     * @param userId
     * @return
     */
    public PfUserVo getUserVo(String userId);

    /**
     * 查找一个角色
     * @param roleId
     * @return
     */
    public PfRoleVo getRoleVo(String roleId);

    /**
     * 查找一个部门
     * @param organId
     * @return
     */
    public PfOrganVo getOrganVo(String organId);

    /**
     * 查找一个部门，根据部门名称
     * @param organName
     * @return
     */
    public PfOrganVo getOrganVoByName(String organName);

    /**
     * 根据参与者获取所有的人员Id
     * @param lstPerformers
     * @return
     */
    public List<String> getAllUserListPerformers(
            List<PerformerModel> lstPerformers);

    /**
     * 获取所有和创建者在同一个部门的人员
     * @param lstPerformers
     * @param userId
     * @return
     */
    public List<String> getUserListPerformersByUserOrgan(
            List<PerformerModel> lstPerformers, String userId);

    /**
     * 保存用户和密码
     * @param userId
     * @param loginPassWord
     * @return
     */
    public boolean savePassWord(String userId, String loginPassWord);

    /**
     * 保存用户签名密码
     * @param userId 用户Id
     * @param signPassword 签名密码
     * @return
     */
    public boolean saveSignPassword(String userId,String signPassword);

    /**
     * 保存用户的配置信息
     * @param vo
     * @return
     */
    public void saveConfig(PfConfigVo vo);

    /**
     * 获取用户的配置信息
     * @param userId
     * @return
     */
    public PfConfigVo getConfigVo(String userId);

    /**
     * 获得一个用户的regionCode
     * @param userId
     * @return
     */
    public String getUserRegionCode(String userId);

    public List<PfOrganVo> getOrganListByRemark(String remark);

    /**
     * 查询一个部门和角色下的人员
     *
     * @param roleId
     * @param organId
     * @return
     */
    public List<PfUserVo> getUserListByRoleAndOrgan(String roleId, String organId);

    /**
     * 查询多个部门和角色下的人员
     *
     * @param roleId
     * @param organList
     * @return
     */
    public List<PfUserVo> getUserListByRoleAndOrganIds(String roleId, List<String> organList);

    /**
     * 根据用户Id获得地狱码
     *
     * @param userId
     * @return
     */
    public String getRegionCodeByUserId(String userId);

    /**
     * 根据地域码获得部门列表
     *
     * @param regionCode
     * @return
     */
    public List<PfOrganVo> getOrganByRegionCode(String regionCode);

    /**
     * 获取部门列表
     *
     * @return
     */
    public List<PfOrganVo> getOrganList();

    /**
     * 获取角色列表
     *
     * @return
     */
    public List<PfRoleVo> getRoleList();

    /**
     * 获得所有用户
     *
     * @return
     */
    public List<PfUserVo> getAllUsers();

    /**
     * 根据部门名查找用户
     *
     * @return
     */
    public List<PfUserVo> getUsersByOrganName(String orginName);

    /**
     * 更新用户信息
     *
     * @param userVo
     */
    void updateUser(PfUserVo userVo);

    /**
     * 获取所有部门
     *
     * @return
     */
    public List<PfOrganVo> getAllOrganList();

    /**
     * 获取有效用户代理人列表
     *
     * @param userId
     * @return
     */
    public String getUserAgentList(String userId);

    /**
     * 获得有效任务代理信息列表
     *
     * @param userId
     * @return
     */
    public List<PfTaskAgentVo> getAgentUserList(String userId);

    /**
     * 增加任务代理
     *
     * @param pfTaskAgentVo
     */
    public void insertTaskAgent(PfTaskAgentVo pfTaskAgentVo);

    /**
     * 删除任务代理
     *
     * @param taskAgentId
     */
    public void deleteTaskAgent(String taskAgentId);

    /**
     * 根据角色的名称获取角色列表模糊
     *
     * @param roleName
     * @return
     */
    public List<PfRoleVo> getRoleVoListByRoleNameFuzzy(String roleName);

    /**
     * 根据regionde获取部门列表
     *
     * @param regionCode
     * @return
     */
    public List<PfOrganVo> getOrganListByRegionCode(String regionCode);

    /**
     * 获取委托用户，是否有委托的用户
     * @param userId
     * @return
     */
    public List<PfTaskAgentVo> getTaskAgentListByUser(String userId);

    /**
     * 获取所有和工作流项目所在地区在同一个部门的人员
     * @param lstPerformers
     * @param districtCode
     * @return
     */
    public List<String> getUserListPerformersByDistrict(
            List<PerformerModel> lstPerformers, String districtCode);
}
