package com.gtis.plat.service;

import com.gtis.plat.vo.PfSignVo;

import java.util.HashMap;
import java.util.List;

public interface SysSignService {

    public List<PfSignVo> getSignList(String signKey, String proId);

    public List<PfSignVo> getSignListByUserId(String signKey, String proId, String userId);

    /**
     * 获取签名信息，无图片信息
     * @param signId
     * @return
     */
    public PfSignVo getSign(String signId);

    /**
     * 获取签名图片
     * @param signId
     * @return
     */
    public PfSignVo getSignImage(String signId);

    /**
     * 插入自动签名
     * @param signVo
     * @return
     */
    public boolean insertAutoSign(PfSignVo signVo);

    /**
     * 更新自动签名
     * @param signVo
     * @return
     */
    public boolean updateAutoSign(PfSignVo signVo);

    /**
     * 更新签名属性
     * @param signVo
     * @return
     */
    public boolean updateSign(PfSignVo signVo);
    /**
     * 添加手动签名
     * @param userId
     * @param signKey
     * @param imgStr
     * @return
     */
    public String AddCustomSign(String userId,String proId,String signKey,String imgStr);

    /**
     * 新增手动签名
     * @param pfSignVo 签名对象
     * @param imgStr
     * @return
     */
    public String addCustomSign(PfSignVo pfSignVo,String imgStr);

    /**
     * 更新自定义签名
     * @param signId
     * @param imgStr
     * @return
     */
    public boolean UpdateCustomSignPic(String signId,String imgStr);

    /**
     * 删除签名
     * @param signId
     * @return
     */
    public boolean deleteSign(String signId);

    /**
     * 按某字段排序获得签名
     * @param map
     * @return
     */
    public List<PfSignVo> getSignListOrderfield(HashMap map);
}