package com.gtis.plat.service;

import java.util.Date;
import java.util.List;

/**
 * 工作日的计算类
 * jibo
 *
 */
public interface SysCalendarService {

    /**
     * 得到一个工作日的办理超期时间
     * @param beginDate
     * @param timeLimit
     * @return
     */
    Date getOverTime(Date beginDate,String timeLimit);

    /**
     * 获得两个时间相差的工作小时
     * @param beginDate
     * @param endDate
     * @return
     */
    double getWorkDayHours(Date beginDate,Date endDate);
    /**
     * 获取最大的日期
     * @return
     */
    Date getMaxDate();

    /**
     * 判断是否非工作日(节假日)
     * @param bDate
     * @return
     */
    boolean IsHoliday(Date bDate);

    /**
     * 得到下一个工作日的工作时间
     * @param bDate
     * @return
     */
    Date getNextWorkDay(Date bDate);

    /**
     * 重新刷新加载工作日和节假日
     */
    void reloadWorkdaysAndHolidays();

    /**
     * 返回剩余时间数量，可以是小时也可以是天数
     * @param overDate
     * @return
     */
    int getTimeLeft(Date overDate);

    /**
     * 获得两个时间之间工作日
     * @param beginDate
     * @param endDate
     * @return
     */
    public List<Date> getWorkDateList(Date beginDate, Date endDate);
    /**
     * 获得两个时间之间节假日
     * @param beginDate
     * @param endDate
     * @return
     */
    public List<Date> getHolidayList(Date beginDate, Date endDate);
}
