package com.gtis.generic.security;

import org.springframework.security.ui.logout.LogoutFilter;
import org.springframework.security.ui.logout.LogoutHandler;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 自定义Spring logout过滤器,将原先的logoutSuccessUrl拆成两部分，一个是cas的logout地址（logoutSuccessUrl），
 * 一个是后面service的参数值（logoutSuccessUrlParameter），便于根据访问IP来生成动态地址
 * @author <a href="mailto:shenjian@gtmap.cn">jane</a>
 * @version 1.0, 2015/12/24
 */
public class EgovLogoutFilter extends LogoutFilter {

    private String logoutSuccessUrlParameter;

    public String getLogoutSuccessUrlParameter() {
        return logoutSuccessUrlParameter;
    }

    public void setLogoutSuccessUrlParameter(String logoutSuccessUrlParameter) {
        this.logoutSuccessUrlParameter = logoutSuccessUrlParameter;
    }

    public EgovLogoutFilter(String logoutSuccessUrl, LogoutHandler[] handlers) {
        super(logoutSuccessUrl, handlers);
    }

    public String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String targetUrl = getLogoutSuccessUrl();
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(request.isSecure() ? "https://" : "http://");
        urlBuilder.append(request.getServerName());
        urlBuilder.append(":");
        urlBuilder.append(request.getServerPort());
        String urlBase = urlBuilder.toString();

        if(!targetUrl.startsWith("http://") && !targetUrl.startsWith("https://"))
            targetUrl=urlBase+targetUrl;

        if(!logoutSuccessUrlParameter.startsWith("http://") && !logoutSuccessUrlParameter.startsWith("https://"))
            targetUrl += "?service="+urlBase+logoutSuccessUrlParameter;
        else
            targetUrl += "?service="+logoutSuccessUrlParameter;

        if (!StringUtils.hasLength(targetUrl)) {
            targetUrl = "/";
        }

        return targetUrl;
    }


}
