package com.gtis.common.util;

import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import java.security.SecureRandom;
import java.util.Calendar;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 11-9-1
 * Time: 上午8:34
 * To change this template use File | Settings | File Templates.
 */


public class TokenUtils {

    private static String ENCRYPT_KEY = "gtis123456789";  //加密密钥
    private static long TIME_MILLIS = 60000;  //1分钟


    public static String BuildToken() throws Exception {
        String timeStr = String.valueOf(Calendar.getInstance().getTimeInMillis());
        return encrypt(timeStr);
    }

    public static Boolean CheckToken(String tokenStr) throws Exception {
        String timeStr = decrypt(tokenStr);
        long time = Calendar.getInstance().getTimeInMillis();
        long result = time - Long.parseLong(timeStr);
        return result < TIME_MILLIS;
    }

    /**
     * 加密方法
     *
     * @param str
     * @return
     * @throws Exception
     */

    public static String encrypt(String str) throws Exception {
        // DES算法要求有一个可信任的随机数源
        SecureRandom sr = new SecureRandom();
        // 从原始密匙数据创建一个DESKeySpec对象
        DESKeySpec dks = new DESKeySpec(ENCRYPT_KEY.getBytes());
        // 创建一个密匙工厂，然后用它把DESKeySpec转换成一个SecretKey对象
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey key = keyFactory.generateSecret(dks);
        // Cipher对象实际完成加密操作
        Cipher cipher = Cipher.getInstance("DES");
        // 用密匙初始化Cipher对象
        cipher.init(Cipher.ENCRYPT_MODE, key, sr);
        // 现在，获取数据并加密
        byte data[] = str.getBytes();
        // 正式执行加密操作
        byte[] encryptedData = cipher.doFinal(data);
        return Base64.encodeBase64String(encryptedData);
    }

    /**
     * 解密方法
     *
     * @param str
     * @throws Exception
     */

    public static String decrypt(String str)
            throws Exception {
        // DES算法要求有一个可信任的随机数源
        SecureRandom sr = new SecureRandom();
        // 从原始密匙数据创建一个DESKeySpec对象
        DESKeySpec dks = new DESKeySpec(ENCRYPT_KEY.getBytes());
        // 创建一个密匙工厂，然后用它把DESKeySpec对象转换成一个SecretKey对象
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey key = keyFactory.generateSecret(dks);
        // Cipher对象实际完成解密操作
        Cipher cipher = Cipher.getInstance("DES");
        // 用密匙初始化Cipher对象
        cipher.init(Cipher.DECRYPT_MODE, key, sr);
        // 正式执行解密操作
        byte decryptedData[] = cipher.doFinal(Base64.decodeBase64(str));
        return new String(decryptedData);
    }

    public static void main(String[] args) throws Exception {
        String key = BuildToken();
        System.out.println("生成密钥===>" + key);
        System.out.println("验证密钥===>" + CheckToken(key));
    }
}
