package com.gtis.support.hibernate;

import org.hibernate.cfg.ImprovedNamingStrategy;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 11-12-29
 */
public class TPrefixNamingStrategy extends ImprovedNamingStrategy {
    private static final long serialVersionUID = -5422825505217904901L;

    @Override
    public String classToTableName(String tableName) {
        return "t_" + super.classToTableName(tableName);
    }

    @Override
    public String tableName(String tableName) {
        if (!tableName.startsWith("t_")) {
            tableName = "t_" + tableName;
        }
        return super.tableName(tableName);
    }
}
