package com.gtis.search;

import com.gtis.util.ThreadPool;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-10
 */
public class RsyncIndexManager implements IndexManager {
    protected static final Logger LOG = LoggerFactory.getLogger(RsyncIndexManager.class);
    private IndexManager indexManager;

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void update(final Index... indexes) {
        if (ArrayUtils.isEmpty(indexes)) {
            return;
        }
        ThreadPool.execute(new Runnable() {
            public void run() {
                try {
                    indexManager.update(indexes);
                } catch (Exception e) {
                    LOG.error("Error to update index [" + Arrays.toString(indexes) + "],message:[" + e.getMessage() + "]");
                }
            }
        });
    }

    public void remove(final String... ids) {
        if (ArrayUtils.isEmpty(ids)) {
            return;
        }
        ThreadPool.execute(new Runnable() {
            public void run() {
                try {
                    indexManager.remove(ids);
                } catch (Exception e) {
                    LOG.error("Error to remove index [id:" + Arrays.toString(ids) + "],message:[" + e.getMessage() + "]");
                }
            }
        });
    }

    public void reloadBusiness(final String businessId) {
        ThreadPool.execute(new Runnable() {
            public void run() {
                try {
                    indexManager.reloadBusiness(businessId);
                } catch (Exception e) {
                    LOG.error("Error to reload business [" + businessId + "],message:[" + e.getMessage() + "]");
                }
            }
        });
    }
}
