package com.gtis.plat.service;

import com.gtis.plat.vo.PfPartitionInfoVo;
import org.dom4j.Document;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

public interface SysAuthorService {

    /**
     * 任务列表 功能分区的可用列表
     *
     * @param taskId
     * @param rId
     */
    public abstract List<PfPartitionInfoVo> getTaskFormFunAuthorList(
            String taskId, String roles, String rId);

    public abstract List<PfPartitionInfoVo> getTaskFormAuthorList(String taskId, String roles, String rId);


    public abstract List<PfPartitionInfoVo> getProjectResrouceFunAuthorList(
            String proid, String roles, String rId);

    public abstract List<PfPartitionInfoVo> getSystemResrouceFunAuthorList(String roles, String rId);

    /**
     * 任务列表
     *
     * @param doc
     * @param taskId
     * @param resourceId
     */
    public abstract void processXmlDocument(Document doc, String taskId,
                                            String resourceId);

    /**
     * 项目列表
     *
     * @param doc
     * @param taskId
     * @param resourceId
     */
    public abstract void processProjectXmlDocument(Document doc,
                                                   HttpServletRequest request, String resourceId);

    /**
     * 系统主界面
     *
     * @param doc
     * @param lstElement
     */
    public abstract void processSystemXmlDocument(Document doc,
                                                  HttpServletRequest request, String resourceId);

    public abstract void processXmlReadOnly(Document doc);

    public abstract String getAuthorJsHtml(List<PfPartitionInfoVo> lstElement);

    public boolean queryTaskElement(String wiid, String taskid, String rId, String eleName);

}