/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: User.java
 *
 * LastModified: 2009-09-23 10:17:15
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.generic.security;

import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-23
 */
public class User implements UserDetails {

    private String id;
    private String username;
    private static final long serialVersionUID = 5969746713040539254L;

    public void setUsername(String username) {
        this.username = username;
        //根据用户名称获取用户id
        //SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
        //PfUserVo userVo=userService.getUserByloginName(username);
        this.id = username;
    }

    public GrantedAuthority[] getAuthorities() {
        return new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_USER")};
    }

    public String getId() {
        return id;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return null;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isAdmin() {
        return false;
    }
}
