package com.gtis.dform.xml;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;

/**
 * Created by IntelliJ IDEA.
 * User: jibo
 * Date: 11-9-5
 * Time: 下午1:41
 * To change this template use File | Settings | File Templates.
 */
public class FormXmlModel {
    String id;      //唯一编号
    String name;   //类型,nodename
    String content; //类型
    String key;  //结果名称

    /**
     * 根据xml中得node解析
     *
     * @param node
     */
    public static FormXmlModel parser(Node node) {
        FormXmlModel xmlMode = new FormXmlModel();
        xmlMode.name = node.getName();
        xmlMode.id = node.valueOf("@id");
        xmlMode.content = node.getText().trim();
        if (StringUtils.isNotBlank(node.valueOf("@key")))
            xmlMode.key = node.valueOf("@key");
        return xmlMode;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}
