package com.gtis.web;

import com.gtis.plat.vo.PfConfigVo;
import com.gtis.plat.vo.UserInfo;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class SessionUtil {

    private static final UserInfo guest;

    static {
        guest = new UserInfo();
        guest.setAdmin(false);
        guest.setUsername("guest");
        guest.setId("guest");
    }

    /**
     * 从session中获取用户信息
     *
     * @param request
     * @return
     */
    @Deprecated
    public static UserInfo getUserInfo(HttpServletRequest request) {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null) {
            Authentication authentication = context.getAuthentication();
            if (authentication != null)
                return (UserInfo) authentication.getPrincipal();
        }
        return null;
    }

    public static UserInfo getCurrentUser() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null) {
            Authentication authentication = context.getAuthentication();
            if (authentication != null) {
                if (authentication instanceof AnonymousAuthenticationToken) {
                    return guest;
                }
                return (UserInfo) authentication.getPrincipal();
            }
        }
        return null;
    }

    public static String getCurrentUserId() {
        UserInfo user = getCurrentUser();
        return user != null ? user.getId() : null;
    }

    public static String getCurrentUserIds() {
        UserInfo info = getCurrentUser();
        return info.getUsersIdAll();
    }

    /**
     * 用户配置信息
     *
     * @param request
     * @return
     */
    @Deprecated
    public static PfConfigVo getUserConfig(HttpServletRequest request) {
        UserInfo info = getUserInfo(request);
        return info.getConfig();
    }

    /**
     * 只获取用户编号
     *
     * @param request
     * @return
     */
    @Deprecated
    public static String getUserId(HttpServletRequest request) {
        UserInfo info = getUserInfo(request);
        if (info != null)
            return info.getId();
        else
            return "";
    }

    @Deprecated
    public static String getUserIds(HttpServletRequest request) {
        UserInfo info = getUserInfo(request);
        return info.getUsersIdAll();
    }

    /**
     * 获取当前用户信息
     *
     * @param request
     * @return
     */
    @Deprecated
    public static String getUserName(HttpServletRequest request) {
        UserInfo userInfo = getUserInfo(request);
        if (userInfo != null)
            return userInfo.getUsername();
        else
            return "";
    }

    /**
     * 获取当前时间 yyyy年MM月dd日 星期日
     *
     * @return
     */
    public static String getCurTime() {
        String result = "";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat tempDate = new SimpleDateFormat("yyyy年MM月dd日" + " ");
        result = tempDate.format(cal.getTime());
        result = result + " 星期" + getChineseDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
        return result;
    }

    public static String getChineseDayOfWeek(int dayOfWeek) {
        switch (dayOfWeek) {
            case Calendar.MONDAY:
                return "一";
            case Calendar.TUESDAY:
                return "二";
            case Calendar.WEDNESDAY:
                return "三";
            case Calendar.THURSDAY:
                return "四";
            case Calendar.FRIDAY:
                return "五";
            case Calendar.SATURDAY:
                return "六";
            case Calendar.SUNDAY:
                return "日";
        }
        return "";
    }
}
