package com.gtis.search;

import java.io.Serializable;
import java.util.HashMap;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-10
 */
public final class Category extends AbstractCategory implements Serializable, Cloneable {
    private static final long serialVersionUID = 6615556447561762184L;
    private String businessId;
    protected String[] roleIds = {"0"};

    public String getBusinessId() {
        return businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    public String[] getRoleIds() {
        return roleIds;
    }

    public void setRoleIds(String[] roleIds) {
        this.roleIds = roleIds;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Category && getId().equals(((Category) obj).getId());
    }

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public Category clone() {
        try {
            Category cat = (Category) super.clone();
            cat.setTpls(new HashMap<String, String>(getTpls()));
            cat.setTplVars(new HashMap<String, Serializable>(getTplVars()));
            return cat;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }
}
